/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.client.extension.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.uad.constants.ClientExtensionUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the client extension entry rel UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link ClientExtensionEntryRelUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseClientExtensionEntryRelUADAnonymizer
	extends DynamicQueryUADAnonymizer<ClientExtensionEntryRel> {

	@Override
	public void autoAnonymize(
			ClientExtensionEntryRel clientExtensionEntryRel, long userId,
			User anonymousUser)
		throws PortalException {

		if (clientExtensionEntryRel.getUserId() == userId) {
			clientExtensionEntryRel.setUserId(anonymousUser.getUserId());
			clientExtensionEntryRel.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(clientExtensionEntryRel, anonymousUser);
		}

		clientExtensionEntryRelLocalService.updateClientExtensionEntryRel(
			clientExtensionEntryRel);
	}

	@Override
	public void delete(ClientExtensionEntryRel clientExtensionEntryRel)
		throws PortalException {

		clientExtensionEntryRelLocalService.deleteClientExtensionEntryRel(
			clientExtensionEntryRel);
	}

	@Override
	public Class<ClientExtensionEntryRel> getTypeClass() {
		return ClientExtensionEntryRel.class;
	}

	protected void autoAnonymizeAssetEntry(
		ClientExtensionEntryRel clientExtensionEntryRel, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(clientExtensionEntryRel);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return clientExtensionEntryRelLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return ClientExtensionUADConstants.
			USER_ID_FIELD_NAMES_CLIENT_EXTENSION_ENTRY_REL;
	}

	protected AssetEntry fetchAssetEntry(
		ClientExtensionEntryRel clientExtensionEntryRel) {

		return assetEntryLocalService.fetchEntry(
			ClientExtensionEntryRel.class.getName(),
			clientExtensionEntryRel.getClientExtensionEntryRelId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected ClientExtensionEntryRelLocalService
		clientExtensionEntryRelLocalService;

}