/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.change.tracking.uad.anonymizer;

import com.liferay.change.tracking.model.CTEntryAggregate;
import com.liferay.change.tracking.service.CTEntryAggregateLocalService;
import com.liferay.change.tracking.uad.constants.CTUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the ct entry aggregate UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link CTEntryAggregateUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseCTEntryAggregateUADAnonymizer
	extends DynamicQueryUADAnonymizer<CTEntryAggregate> {

	@Override
	public void autoAnonymize(
			CTEntryAggregate ctEntryAggregate, long userId, User anonymousUser)
		throws PortalException {

		if (ctEntryAggregate.getUserId() == userId) {
			ctEntryAggregate.setUserId(anonymousUser.getUserId());
			ctEntryAggregate.setUserName(anonymousUser.getFullName());
		}

		ctEntryAggregateLocalService.updateCTEntryAggregate(ctEntryAggregate);
	}

	@Override
	public void delete(CTEntryAggregate ctEntryAggregate)
		throws PortalException {

		ctEntryAggregateLocalService.deleteCTEntryAggregate(ctEntryAggregate);
	}

	@Override
	public Class<CTEntryAggregate> getTypeClass() {
		return CTEntryAggregate.class;
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return ctEntryAggregateLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return CTUADConstants.USER_ID_FIELD_NAMES_CT_ENTRY_AGGREGATE;
	}

	@Reference
	protected CTEntryAggregateLocalService ctEntryAggregateLocalService;

}