"use strict";

Liferay.Loader.define("change-tracking-change-lists-web@1.0.16/js/PublishChangeList.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-checkbox', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-soy', 'frontend-js-web/liferay/compat/modal/Modal.es', 'frontend-js-web/liferay/toast/commands/OpenToast.es', './PublishChangeList.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.PublishChangeList = void 0;

  require("frontend-taglib-clay$clay-checkbox");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  require("frontend-js-web/liferay/compat/modal/Modal.es");

  var _OpenToast = require("frontend-js-web/liferay/toast/commands/OpenToast.es");

  var _PublishChangeList = _interopRequireDefault(require("./PublishChangeList.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Handles the Change Lists publication dialog.
   */
  var PublishChangeList =
  /*#__PURE__*/
  function (_Component) {
    _inherits(PublishChangeList, _Component);

    function PublishChangeList() {
      _classCallCheck(this, PublishChangeList);

      return _possibleConstructorReturn(this, _getPrototypeOf(PublishChangeList).apply(this, arguments));
    }

    _createClass(PublishChangeList, [{
      key: "created",
      value: function created() {
        this._disablePublishButton = this.changeListHasCollision;
      }
    }, {
      key: "_handleCloseDialogClick",
      value: function _handleCloseDialogClick(event) {
        this.refs.modal.visible = false;
      }
    }, {
      key: "_handlePublishClick",
      value: function _handlePublishClick(event) {
        this._publishChangeList();
      }
    }, {
      key: "_checkoutProduction",
      value: function _checkoutProduction() {
        var _this = this;

        this.refs.modal.visible = false;
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var body = {
          credentials: 'include',
          headers: headers,
          method: 'POST'
        };
        fetch(this.urlCheckoutProduction, body).then(function (response) {
          if (response.status === 202) {
            Liferay.Util.navigate(_this.urlChangeListsHistory);
          }
        });
      }
    }, {
      key: "_publishChangeList",
      value: function _publishChangeList() {
        var _this2 = this;

        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: this.urlPublishChangeList.type
        };
        var url = this.urlPublishChangeList.href + '?userId=' + Liferay.ThemeDisplay.getUserId() + '&ignoreCollision=' + this.ignoreCollision;
        fetch(url, init).then(function (response) {
          if (response.status === 202) {
            (0, _OpenToast.openToast)({
              message: Liferay.Util.sub(Liferay.Language.get('publishing-x-has-started-successfully'), AUI().Lang.String.escapeHTML(_this2.changeListName)),
              title: Liferay.Language.get('success'),
              type: 'success'
            });

            _this2._checkoutProduction();
          } else if (response.status === 400) {
            response.json().then(function (data) {
              (0, _OpenToast.openToast)({
                message: Liferay.Util.sub(Liferay.Language.get('an-error-occured-when-trying-publishing-x-x'), AUI().Lang.String.escapeHTML(_this2.changeListName), data.message),
                title: Liferay.Language.get('error'),
                type: 'danger'
              });
            });
          }
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-when-trying-publishing-x'), AUI().Lang.String.escapeHTML(_this2.changeListName));
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_handleIgnoreCollisionChange",
      value: function _handleIgnoreCollisionChange(event) {
        if (event.target.checked) {
          this.ignoreCollision = true;
          this._disablePublishButton = false;
        } else {
          this.ignoreCollision = false;
          this._disablePublishButton = true;
        }
      }
    }]);

    return PublishChangeList;
  }(_metalComponent.default);
  /**
   * State definition.
   *
   * @ignore
   * @static
   * @type {!Object}
   */

  exports.PublishChangeList = PublishChangeList;
  PublishChangeList.STATE = {
    _disablePublishButton: _metalState.Config.bool().value(false),
    changeListDescription: _metalState.Config.string(),
    changeListHasCollision: _metalState.Config.bool().value(false),
    changeListName: _metalState.Config.string(),
    ignoreCollision: _metalState.Config.bool(),

    /**
     * Path to the images.
     *
     * @instance
     * @memberOf PublishChangeList
     * @type {String}
     */
    spritemap: _metalState.Config.string().required(),
    urlChangeListsHistory: _metalState.Config.string().required(),
    urlCheckoutProduction: _metalState.Config.string().required(),
    urlPublishChangeList: _metalState.Config.object()
  }; // Register component

  _metalSoy.default.register(PublishChangeList, _PublishChangeList.default);

  var _default = PublishChangeList;
  exports.default = _default;
  //# sourceMappingURL=PublishChangeList.es.js.map
});
//# sourceMappingURL=PublishChangeList.es.js.map