"use strict";

Liferay.Loader.define("change-tracking-change-lists-web@1.0.16/js/Overview.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-icon', 'frontend-js-metal-web$metal-soy', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/toast/commands/OpenToast.es', './PublishChangeList.es', './Overview.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.Overview = void 0;

  require("frontend-taglib-clay$clay-icon");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _OpenToast = require("frontend-js-web/liferay/toast/commands/OpenToast.es");

  var _PublishChangeList = require("./PublishChangeList.es");

  var _Overview = _interopRequireDefault(require("./Overview.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var SPLIT_REGEX = /({\d+})/g;
  /**
   * Provides the component for the Overview configuration screen.
   */

  var Overview =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(Overview, _PortletBase);

    function Overview() {
      _classCallCheck(this, Overview);

      return _possibleConstructorReturn(this, _getPrototypeOf(Overview).apply(this, arguments));
    }

    _createClass(Overview, [{
      key: "created",
      value: function created() {
        this._render();

        this._fetchProductionCollection();
      }
    }, {
      key: "_checkoutCollection",
      value: function _checkoutCollection(ctCollectionId, production) {
        var _this = this;

        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var body = {
          credentials: 'include',
          headers: headers,
          method: 'POST'
        };
        var url = this.urlCollectionsBase + '/' + ctCollectionId + '/checkout?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&userId=' + Liferay.ThemeDisplay.getUserId();
        fetch(url, body).then(function (response) {
          if (response.status === 202) {
            Liferay.fire('refreshChangeTrackingIndicator');

            if (production) {
              Liferay.Util.navigate(_this.urlSelectProduction);
            } else {
              _this._render();
            }
          } else if (response.status === 400) {
            response.json().then(function (data) {
              (0, _OpenToast.openToast)({
                message: Liferay.Util.sub(Liferay.Language.get('an-error-occured-when-trying-to-check-x-out-x'), _this.changeListName, data.message),
                title: Liferay.Language.get('error'),
                type: 'danger'
              });
            });
          }
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-when-trying-to-check-x-out'), _this.changeListName);
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_fetchProductionCollection",
      value: function _fetchProductionCollection() {
        var _this2 = this;

        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: 'GET'
        };
        var url = this.urlCollectionsBase + '?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&type=production';
        fetch(url, init).then(function (r) {
          return r.json();
        }).then(function (response) {
          _this2.productionCTCollectionId = response[0].ctCollectionId;
        });
      }
    }, {
      key: "_fetchAll",
      value: function _fetchAll(urls, init) {
        return Promise.all(urls.map(function (url) {
          return fetch(url, init).then(function (r) {
            return r.json();
          }).then(function (data) {
            return data;
          }).catch(function (error) {
            var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-while-getting-data-from-x'), url);
            (0, _OpenToast.openToast)({
              message: message,
              title: Liferay.Language.get('error'),
              type: 'danger'
            });
          });
        }));
      }
    }, {
      key: "_fetchChangeEntries",
      value: function _fetchChangeEntries(url, type) {
        var _this3 = this;

        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: type
        };
        fetch(url, init).then(function (r) {
          return r.json();
        }).then(function (response) {
          return _this3._populateChangeEntries(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-while-getting-data-from-x'), url);
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_fetchCollisions",
      value: function _fetchCollisions(url, type) {
        var _this4 = this;

        this.collisionsLoading = true;
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: type
        };
        fetch(url, init).then(function (r) {
          return r.json();
        }).then(function (response) {
          return _this4._populateCollidingChangeEntries(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-while-getting-data-from-x'), url);
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_fetchRecentCollections",
      value: function _fetchRecentCollections(url, type) {
        var _this5 = this;

        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: type
        };
        fetch(url, init).then(function (r) {
          return r.json();
        }).then(function (response) {
          return _this5._populateChangeListsDropdown(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Util.sub(Liferay.Language.get('an-error-occured-while-getting-data-from-x'), url);
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_handleClickPublish",
      value: function _handleClickPublish(event) {
        new _PublishChangeList.PublishChangeList({
          changeListDescription: this.descriptionActiveChangeList,
          changeListHasCollision: this.hasCollision,
          changeListName: this.headerTitleActiveChangeList,
          spritemap: themeDisplay.getPathThemeImages() + '/lexicon/icons.svg',
          urlChangeListsHistory: this.urlChangeListsHistory,
          urlCheckoutProduction: this.urlCollectionsBase + '/' + this.productionCTCollectionId + '/checkout?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&userId=' + Liferay.ThemeDisplay.getUserId(),
          urlPublishChangeList: this.urlActiveCollectionPublish
        });
      }
    }, {
      key: "_handleClickRecentCollections",
      value: function _handleClickRecentCollections(event) {
        event.preventDefault();
        var ok = true;

        if (this.checkoutConfirmationEnabled) {
          var label = this._sub(Liferay.Language.get('do-you-want-to-switch-to-x-change-list'), [event.target.text]);

          ok = confirm(label);
        }

        if (ok) {
          var collectionId = event.target.getAttribute('data-collection-id');
          var production = event.target.getAttribute('data-production');

          this._checkoutCollection(collectionId, production);
        }
      }
    }, {
      key: "_handleClickTrash",
      value: function _handleClickTrash() {
        var _this6 = this;

        var ok = false;

        var label = this._sub(Liferay.Language.get('are-you-sure-you-want-to-delete-x-change-list'), [this.headerTitleActiveChangeList]);

        ok = confirm(label);

        if (ok) {
          var headers = new Headers();
          headers.append('Content-Type', 'application/json');
          headers.append('X-CSRF-Token', Liferay.authToken);
          var body = {
            credentials: 'include',
            headers: headers,
            method: 'DELETE'
          };
          var url = this.urlCollectionsBase + '/' + this.activeCTCollectionId;
          fetch(url, body).then(function (response) {
            if (response.status === 204) {
              Liferay.Util.navigate(_this6.urlSelectProduction);
            } else if (response.status === 404) {
              (0, _OpenToast.openToast)({
                message: _this6._sub(Liferay.Language.get('unable-to-delete-change-list-x-because-it-could-not-be-found'), [_this6.headerTitleActiveChangeList]),
                title: Liferay.Language.get('error'),
                type: 'danger'
              });
            }
          }).catch(function (error) {
            var message = typeof error === 'string' ? error : _this6._sub(Liferay.Language.get('an-error-occured-when-trying-to-delete-x'), [_this6.headerTitleActiveChangeList]);
            (0, _OpenToast.openToast)({
              message: message,
              title: Liferay.Language.get('error'),
              type: 'danger'
            });
          });
        }
      }
    }, {
      key: "_populateChangeEntries",
      value: function _populateChangeEntries(changeEntriesResult) {
        var _this7 = this;

        this.changeEntries = [];
        this.headerButtonDisabled = false;

        if (!changeEntriesResult.items) {
          this.headerButtonDisabled = true;
          return;
        }

        changeEntriesResult.items.forEach(function (changeEntry) {
          var changeTypeStr = Liferay.Language.get('added');

          if (changeEntry.changeType === 1) {
            changeTypeStr = Liferay.Language.get('deleted');
          } else if (changeEntry.changeType === 2) {
            changeTypeStr = Liferay.Language.get('modified');
          }

          var entityNameTranslation = _this7.entityNameTranslations.find(function (entityNameTranslation) {
            return entityNameTranslation.key == changeEntry.contentType;
          });

          _this7.changeEntries.push({
            changeType: changeTypeStr,
            conflict: changeEntry.collision,
            contentType: entityNameTranslation.translation,
            lastEdited: new Intl.DateTimeFormat(Liferay.ThemeDisplay.getBCP47LanguageId(), {
              day: 'numeric',
              hour: 'numeric',
              minute: 'numeric',
              month: 'numeric',
              year: 'numeric'
            }).format(new Date(changeEntry.modifiedDate)),
            site: changeEntry.siteName,
            title: changeEntry.title,
            userName: changeEntry.userName,
            version: String(changeEntry.version)
          });
        });

        if (this.changeEntries.length === 0) {
          this.headerButtonDisabled = true;
        }
      }
    }, {
      key: "_populateChangeListsDropdown",
      value: function _populateChangeListsDropdown(collectionResults) {
        var _this8 = this;

        this.changeListsDropdownMenu = [];
        collectionResults.forEach(function (ctCollection) {
          _this8.changeListsDropdownMenu.push({
            ctCollectionId: ctCollection.ctCollectionId,
            label: ctCollection.name
          });
        });
      }
    }, {
      key: "_populateCollidingChangeEntries",
      value: function _populateCollidingChangeEntries(collisionsResult) {
        if (collisionsResult.items) {
          this.collisionsCount = collisionsResult.items.length;

          if (this.collisionsCount > 0) {
            this.hasCollision = true;
          }
        }

        this.collisionsTooltip = Liferay.Util.sub(Liferay.Language.get('collision-detected-for-x-change-lists'), this.collisionsCount);
        this.collisionsLoading = false;
      }
    }, {
      key: "_populateFields",
      value: function _populateFields(requestResult) {
        var activeCollection = requestResult[0];
        var productionInformation = requestResult[1];
        var userSettings = requestResult[2];
        this.activeCTCollectionId = activeCollection[0].ctCollectionId;

        if (activeCollection !== undefined && activeCollection.length == 1) {
          activeCollection = activeCollection[0];
        }

        if (activeCollection !== undefined) {
          var foundEntriesLink = activeCollection.links.find(function (link) {
            return link.rel === 'entries';
          });

          if (foundEntriesLink) {
            this._fetchCollisions(foundEntriesLink.href + '?collision=true', foundEntriesLink.type);

            this._fetchChangeEntries(foundEntriesLink.href, foundEntriesLink.type);
          }

          this.urlActiveCollectionPublish = activeCollection.links.find(function (link) {
            return link.rel === 'publish';
          }); // Changes

          this.changes = {
            added: activeCollection.additionCount,
            deleted: activeCollection.deletionCount,
            modified: activeCollection.modificationCount
          }; // Active Change List Description

          this.descriptionActiveChangeList = activeCollection.description; // Change Lists dropdown Menu

          var urlRecentCollections = this.urlCollectionsBase + '?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&userId=' + Liferay.ThemeDisplay.getUserId() + '&type=recent&limit=5&sort=modifiedDate:desc';

          this._fetchRecentCollections(urlRecentCollections, 'GET'); // Active Change List Header Title


          this.headerTitleActiveChangeList = activeCollection.name; // Initial Fetch

          this.initialFetch = true;
        }

        if (productionInformation !== undefined && productionInformation.length == 1) {
          productionInformation = productionInformation[0];
        }

        if (productionInformation !== undefined && productionInformation.ctcollection !== undefined && productionInformation.ctcollection.name !== undefined) {
          this.descriptionProductionInformation = productionInformation.ctcollection.description;
          this.headerTitleProductionInformation = productionInformation.ctcollection.name;
          var publishDate = new Date(productionInformation.date);
          this.publishedBy = {
            dateTime: new Intl.DateTimeFormat(Liferay.ThemeDisplay.getBCP47LanguageId(), {
              day: 'numeric',
              hour: 'numeric',
              minute: 'numeric',
              month: 'numeric',
              year: 'numeric'
            }).format(publishDate),
            userInitials: productionInformation.userInitials,
            userName: productionInformation.userName,
            userPortraitURL: productionInformation.userPortraitURL
          };
          this.productionFound = true;
        } else {
          this.productionFound = false;
        }

        if (userSettings) {
          this.checkoutConfirmationEnabled = userSettings.checkoutCTCollectionConfirmationEnabled;
        }
      }
    }, {
      key: "_render",
      value: function _render() {
        var _this9 = this;

        var urlActiveCollection = this.urlCollectionsBase + '?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&userId=' + Liferay.ThemeDisplay.getUserId() + '&type=active';
        var urls = [urlActiveCollection, this.urlProductionInformation, this.urlUserSettings];
        this.initialFetch = false;
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var init = {
          credentials: 'include',
          headers: headers,
          method: 'GET'
        };

        this._fetchAll(urls, init).then(function (result) {
          return _this9._populateFields(result);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Language.get('an-error-occured-while-parsing-data');
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_sub",
      value: function _sub(langKey, args) {
        var keyArray = langKey.split(SPLIT_REGEX).filter(function (val) {
          return val.length !== 0;
        });

        for (var i = 0; i < args.length; i++) {
          var arg = args[i];
          var indexKey = "{".concat(i, "}");
          var argIndex = keyArray.indexOf(indexKey);

          while (argIndex >= 0) {
            keyArray.splice(argIndex, 1, arg);
            argIndex = keyArray.indexOf(indexKey);
          }
        }

        return keyArray.join('');
      }
    }]);

    return Overview;
  }(_PortletBase2.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  exports.Overview = Overview;
  Overview.STATE = {
    /**
     * Active change tracking collection ID retrieved from the REST service.
     *
     * @default 0
     * @instance
     * @memberOf Overview
     * @type {number}
     */
    activeCTCollectionId: _metalState.Config.number().value(0),

    /**
     * Number of changes for the active change list.
     *
     * @default
     * @instance
     * @memberOf Overview
     * @type {object}
     */
    changes: _metalState.Config.shapeOf({
      added: _metalState.Config.number().value(0),
      deleted: _metalState.Config.number().value(0),
      modified: _metalState.Config.number().value(0)
    }),

    /**
     * Active change list card description.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    descriptionActiveChangeList: _metalState.Config.string(),

    /**
     * Production card description.
     *
     * @default
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    descriptionProductionInformation: _metalState.Config.string(),

    /**
     * JSON array of translation properties.
     *
     * @default
     * @instance
     * @memberOf Overview
     * @type {object}
     */
    entityNameTranslations: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      key: _metalState.Config.string(),
      translation: _metalState.Config.string()
    })),

    /**
     * Change entries for the currently selected change tracking collection.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {object}
     */
    changeEntries: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      changeType: _metalState.Config.string(),
      conflict: _metalState.Config.bool(),
      contentType: _metalState.Config.string(),
      lastEdited: _metalState.Config.string(),
      site: _metalState.Config.string(),
      title: _metalState.Config.string(),
      userName: _metalState.Config.string(),
      version: _metalState.Config.string()
    })),

    /**
     * List of drop down menu items.
     *
     * @default []
     * @instance
     * @memberOf Overview
     * @type {array}
     */
    changeListsDropdownMenu: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      ctCollectionId: _metalState.Config.string(),
      label: _metalState.Config.string()
    })),

    /**
     * Checkout confirmation is enabled.
     *
     * @default true
     * @instance
     * @memberOf Overview
     * @type {boolean}
     */
    checkoutConfirmationEnabled: _metalState.Config.bool().value(true),

    /**
     * Number of collisions loaded (only stored if fetching is in progress).
     *
     * @default true
     * @instance
     * @memberOf Overview
     * @type {boolean}
     */
    collisionsLoading: _metalState.Config.bool().value(true),

    /**
     * Number of collisions.
     *
     * @default true
     * @instance
     * @memberOf Overview
     * @type {boolean}
     */
    collisionsCount: _metalState.Config.number().value(0),
    collisionsTooltip: _metalState.Config.string(),
    hasCollision: _metalState.Config.bool().value(false),

    /**
     * If <code>true</code>, head button is disabled.
     *
     * @default false
     * @instance
     * @memberOf Overview
     * @type {boolean}
     */
    headerButtonDisabled: _metalState.Config.bool().value(false),

    /**
     * Active change list's card header title.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    headerTitleActiveChangeList: _metalState.Config.string(),

    /**
     * Production's card header title.
     *
     * @default
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    headerTitleProductionInformation: _metalState.Config.string(),

    /**
     * If <code>true</code>, an initial fetch has already occurred.
     *
     * @default false
     * @instance
     * @memberOf Overview
     * @type {boolean}
     */
    initialFetch: _metalState.Config.bool().value(false),
    productionCTCollectionId: _metalState.Config.number(),
    productionFound: _metalState.Config.bool().value(false),

    /**
     * Information of who published to production.
     *
     * @instance
     * @memberOf Overview
     * @type {object}
     */
    publisedBy: _metalState.Config.shapeOf({
      dateTime: _metalState.Config.string(),
      userInitials: _metalState.Config.string(),
      userName: _metalState.Config.string(),
      userPortraitURL: _metalState.Config.string()
    }),

    /**
     * BBase REST API URL to the collection resource.
     *
     * @default
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    urlCollectionsBase: _metalState.Config.string(),
    urlActiveCollectionPublish: _metalState.Config.object(),
    urlChangeListsHistory: _metalState.Config.string().required(),

    /**
     * The URL for the REST service to the change entries.
     * @default
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    urlChangeEntries: _metalState.Config.string(),

    /**
     * URL for the REST service to the change tracking production information.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {!string}
     */
    urlProductionInformation: _metalState.Config.string().required(),

    /**
     * URL for the production view.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {!string}
     */
    urlProductionView: _metalState.Config.string().required(),

    /**
     * URL for the list view with production checked out.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    urlSelectProduction: _metalState.Config.string(),

    /**
     * URL for the REST service to the user settings.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {string}
     */
    urlUserSettings: _metalState.Config.string(),

    /**
     * Path of the available icons.
     *
     * @default undefined
     * @instance
     * @memberOf Overview
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required()
  };

  _metalSoy.default.register(Overview, _Overview.default);

  var _default = Overview;
  exports.default = _default;
  //# sourceMappingURL=Overview.es.js.map
});
//# sourceMappingURL=Overview.es.js.map