/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.change.lists.web.internal.portlet.action;

import com.liferay.change.tracking.engine.CTEngineManager;
import com.liferay.change.tracking.exception.CTCollectionNameException;
import com.liferay.change.tracking.exception.NoSuchCollectionException;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.Optional;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_change_tracking_change_lists_web_portlet_ChangeListsPortlet", "mvc.command.name=/change_lists/add_ct_collection", "mvc.command.name=/change_lists/edit_ct_collection"}, service={MVCActionCommand.class})
public class EditCTCollectionMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEngineManager _ctEngineManager;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ctCollectionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ctCollectionId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        try {
            if (ctCollectionId > 0L) {
                this._updateCTCollection(themeDisplay.getUserId(), ctCollectionId, name, description);
            } else {
                CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(themeDisplay.getCompanyId(), name);
                if (ctCollection != null) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"ctCollectionDuplicate");
                    this._portal.copyRequestParameters(actionRequest, actionResponse);
                    actionResponse.setRenderParameter("mvcPath", "/edit_ct_collection.jsp");
                    return;
                }
                this._addCTCollection(themeDisplay.getUserId(), name, description);
            }
        }
        catch (PortalException pe) {
            if (pe instanceof CTCollectionNameException && Validator.isNull((String)pe.getMessage())) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"ctCollectionName");
            }
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
        }
    }

    private void _addCTCollection(long userId, String name, String description) throws PortalException {
        Optional ctCollectionOptional = this._ctEngineManager.createCTCollection(userId, name, description);
        ctCollectionOptional.ifPresent(ctCollection -> this._ctEngineManager.checkoutCTCollection(userId, ctCollection.getCtCollectionId()));
    }

    private void _updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        Optional ctCollectionOptional = this._ctEngineManager.getCTCollectionOptional(ctCollectionId);
        CTCollection ctCollection = (CTCollection)ctCollectionOptional.orElseThrow(NoSuchCollectionException::new);
        this._ctCollectionLocalService.updateCTCollection(userId, ctCollection.getCtCollectionId(), name, description, new ServiceContext());
    }
}

