/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.change.lists.web.internal.display.context;

import com.liferay.change.tracking.configuration.CTConfigurationRegistryUtil;
import com.liferay.change.tracking.engine.CTEngineManager;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.settings.CTSettingsManager;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.soy.util.SoyContext;
import com.liferay.portal.template.soy.util.SoyContextFactoryUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class ChangeListsDisplayContext {
    private static ServiceTracker<CTEngineManager, CTEngineManager> _ctEngineManagerServiceTracker;
    private static ServiceTracker<CTSettingsManager, CTSettingsManager> _ctSettingsManagerServiceTracker;
    private final CTEngineManager _ctEngineManager;
    private final CTSettingsManager _ctSettingsManager;
    private String _displayStyle;
    private String _filterByStatus;
    private final HttpServletRequest _httpServletRequest;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public ChangeListsDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ctEngineManager = (CTEngineManager)_ctEngineManagerServiceTracker.getService();
        this._ctSettingsManager = (CTSettingsManager)_ctSettingsManagerServiceTracker.getService();
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public SoyContext getChangeListsContext() throws Exception {
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.put("entityNameTranslations", (Object)JSONUtil.toJSONArray((List)CTConfigurationRegistryUtil.getContentTypeLanguageKeys(), contentTypeLanguageKey -> JSONUtil.put((String)"key", (Object)contentTypeLanguageKey).put("translation", LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)contentTypeLanguageKey)))).put("namespace", (Object)this._renderResponse.getNamespace()).put("spritemap", (Object)(this._themeDisplay.getPathThemeImages() + "/lexicon/icons.svg")).put("urlCollectionsBase", (Object)(this._themeDisplay.getPortalURL() + "/o/change-tracking/collections")).put("urlProductionInformation", (Object)StringBundler.concat((Object[])new Object[]{this._themeDisplay.getPortalURL(), "/o/change-tracking/processes?companyId=", this._themeDisplay.getCompanyId(), "&type=published-latest"})).put("urlProductionView", (Object)this._themeDisplay.getPortalURL()).put("urlUserSettings", (Object)StringBundler.concat((Object[])new Object[]{this._themeDisplay.getPortalURL(), "/o/change-tracking/configurations/", this._themeDisplay.getCompanyId(), "/user/", this._themeDisplay.getUserId()}));
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._renderRequest, (String)"com_liferay_change_tracking_change_lists_history_web_portlet_ChangeListsHistoryPortlet", (String)"RENDER_PHASE");
        soyContext.put("urlChangeListsHistory", (Object)portletURL.toString());
        portletURL = PortletURLFactoryUtil.create((PortletRequest)this._renderRequest, (String)"com_liferay_change_tracking_change_lists_web_portlet_ChangeListsPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("select", "true");
        soyContext.put("urlSelectChangeList", (Object)portletURL.toString());
        portletURL.setParameter("refresh", "true");
        soyContext.put("urlSelectProduction", (Object)portletURL.toString());
        return soyContext;
    }

    public String getConfirmationMessage(String ctCollectionName) {
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"do-you-want-to-switch-to-x-change-list", (Object)ctCollectionName, (boolean)true);
    }

    public CreationMenu getCreationMenu() {
        CreationMenu creationMenu = new CreationMenu();
        creationMenu.addDropdownItem(dropdownItem -> {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_change_tracking_change_lists_web_portlet_ChangeListsPortlet", (String)"RENDER_PHASE");
            portletURL.setParameter("mvcRenderCommandName", "/change_lists/add_ct_collection");
            portletURL.setParameter("backURL", this._themeDisplay.getURLCurrent());
            dropdownItem.setHref((Object)portletURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"add-change-list"));
        });
        return creationMenu;
    }

    public long getCTCollectionAgeTime(CTCollection ctCollection) {
        if (ctCollection == null) {
            return 0L;
        }
        Date modifiedDate = ctCollection.getModifiedDate();
        return System.currentTimeMillis() - modifiedDate.getTime();
    }

    public Map<Integer, Long> getCTCollectionChangeTypeCounts(long ctCollectionId) {
        return this._ctEngineManager.getCTCollectionChangeTypeCounts(ctCollectionId);
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"icon");
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ChangeListsDisplayContext.this._getFilterUserDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"filter-by-user"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ChangeListsDisplayContext.this._getFilterStatusDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"filter-by-status"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(ChangeListsDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public CTCollection getProductionCTCollection() {
        Optional productionCTCollectionOptional = this._ctEngineManager.getProductionCTCollectionOptional(this._themeDisplay.getCompanyId());
        return productionCTCollectionOptional.orElse(null);
    }

    public SearchContainer<CTCollection> getSearchContainer() {
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._renderRequest, new DisplayTerms((PortletRequest)this._renderRequest), null, "cur", 0, SearchContainer.DEFAULT_DELTA, this._getIteratorURL(), null, "there-are-no-change-lists");
        QueryDefinition queryDefinition = new QueryDefinition();
        DisplayTerms displayTerms = searchContainer.getDisplayTerms();
        String keywords = displayTerms.getKeywords();
        queryDefinition.setAttribute("keywords", (Serializable)((Object)keywords));
        int count = (int)this._ctEngineManager.countByKeywords(this._themeDisplay.getCompanyId(), queryDefinition);
        ArrayList ctCollections = new ArrayList();
        Optional productionCTCollection = this._ctEngineManager.getProductionCTCollectionOptional(this._themeDisplay.getCompanyId());
        if (productionCTCollection.isPresent() && Validator.isNull((String)keywords)) {
            if (searchContainer.getCur() == 1) {
                ctCollections.add(productionCTCollection.get());
            }
            ++count;
        }
        if (searchContainer.getEnd() < count) {
            queryDefinition.setEnd(searchContainer.getEnd() - 1);
        } else {
            queryDefinition.setEnd(searchContainer.getEnd());
        }
        queryDefinition.setOrderByComparator(OrderByComparatorFactoryUtil.create((String)"CTCollection", (Object[])new Object[]{this._getOrderByCol(), this.getOrderByType().equals("asc")}));
        if (searchContainer.getStart() > 0) {
            queryDefinition.setStart(searchContainer.getStart() - 1);
        } else {
            queryDefinition.setStart(searchContainer.getStart());
        }
        ctCollections.addAll(this._ctEngineManager.searchByKeywords(this._themeDisplay.getCompanyId(), queryDefinition));
        searchContainer.setResults(ctCollections);
        searchContainer.setTotal(count);
        return searchContainer;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this._getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "desc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public String getViewSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/change_lists/view");
        portletURL.setParameter("select", "true");
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this._getPortletURL(), this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean hasCollision(long ctCollectionId) {
        Optional ctCollectionOptional = this._ctEngineManager.getCTCollectionOptional(ctCollectionId);
        if (!ctCollectionOptional.isPresent()) {
            return false;
        }
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setStatus(2);
        int ctEntriesCount = this._ctEngineManager.getCTEntriesCount((CTCollection)ctCollectionOptional.get(), null, null, null, null, Boolean.valueOf(true), queryDefinition);
        return ctEntriesCount > 0;
    }

    public boolean hasCTEntries(long ctCollectionId) {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setStatus(2);
        int ctEntriesCount = this._ctEngineManager.getCTEntriesCount(ctCollectionId, queryDefinition);
        return ctEntriesCount > 0;
    }

    public boolean isChangeListActive(long ctCollectionId) {
        long recentCTCollectionId = this._ctEngineManager.getRecentCTCollectionId(this._themeDisplay.getUserId());
        return recentCTCollectionId == ctCollectionId;
    }

    public boolean isCheckoutCtCollectionConfirmationEnabled() {
        return GetterUtil.getBoolean((String)this._ctSettingsManager.getUserCTSetting(this._themeDisplay.getUserId(), "checkoutCTCollectionConfirmationEnabled", "true"));
    }

    private String _getFilterByStatus() {
        if (this._filterByStatus != null) {
            return this._filterByStatus;
        }
        this._filterByStatus = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"status", (String)"all");
        return this._filterByStatus;
    }

    private List<DropdownItem> _getFilterStatusDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ChangeListsDisplayContext.this._getFilterByStatus(), "all"));
                    dropdownItem.setHref(ChangeListsDisplayContext.this._getPortletURL(), new Object[]{"status", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"all"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ChangeListsDisplayContext.this._getFilterByStatus(), "active"));
                    dropdownItem.setHref(ChangeListsDisplayContext.this._getPortletURL(), new Object[]{"status", "active"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"active"));
                });
            }
        };
    }

    private List<DropdownItem> _getFilterUserDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setHref((Object)ChangeListsDisplayContext.this._getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"all"));
                });
            }
        };
    }

    private PortletURL _getIteratorURL() {
        PortletURL currentURL = PortletURLUtil.getCurrent((PortletRequest)this._renderRequest, (MimeResponse)this._renderResponse);
        PortletURL iteratorURL = this._renderResponse.createRenderURL();
        iteratorURL.setParameter("mvcPath", "/view.jsp");
        iteratorURL.setParameter("redirect", currentURL.toString());
        iteratorURL.setParameter("displayStyle", this.getDisplayStyle());
        iteratorURL.setParameter("select", "true");
        return iteratorURL;
    }

    private String _getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ChangeListsDisplayContext.this._getOrderByCol(), "modifiedDate"));
                    dropdownItem.setHref(ChangeListsDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "modifiedDate"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"modified-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(ChangeListsDisplayContext.this._getOrderByCol(), "name"));
                    dropdownItem.setHref(ChangeListsDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)ChangeListsDisplayContext.this._httpServletRequest, (String)"name"));
                });
            }
        };
    }

    private PortletURL _getPortletURL() {
        String orderByType;
        String orderByCol;
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._renderRequest, (String)"com_liferay_change_tracking_change_lists_web_portlet_ChangeListsPortlet", (String)"RENDER_PHASE");
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle");
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(orderByCol = this._getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        portletURL.setParameter("select", "true");
        return portletURL;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CTEngineManager.class);
        ServiceTracker ctEngineManagerServiceTracker = new ServiceTracker(bundle.getBundleContext(), CTEngineManager.class, null);
        ctEngineManagerServiceTracker.open();
        _ctEngineManagerServiceTracker = ctEngineManagerServiceTracker;
        ServiceTracker ctSettingsManagerServiceTracker = new ServiceTracker(bundle.getBundleContext(), CTSettingsManager.class, null);
        ctSettingsManagerServiceTracker.open();
        _ctSettingsManagerServiceTracker = ctSettingsManagerServiceTracker;
    }
}

