"use strict";

Liferay.Loader.define("change-tracking-change-lists-indicator-web@1.0.18/js/ChangeListsIndicator.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', './ChangeListsIndicator.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalEvents = require("frontend-js-metal-web$metal-events");

  var _ChangeListsIndicator = _interopRequireDefault(require("./ChangeListsIndicator.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  var BLUE_BACKGROUND_TOOLTIP_CSS_CLASS_NAME = 'tooltip-background-blue';
  var CHANGE_LISTS_INDICATOR_QUERY_SELECTOR = '[data-change-lists-indicator]';
  var GREEN_BACKGROUND_TOOLTIP_CSS_CLASS_NAME = 'tooltip-background-green';
  var PRODUCTION_COLLECTION_ID = 0;
  var TOOLTIP_QUERY_SELECTOR = '.yui3-widget.tooltip';
  /**
   * Component for the Change Lists indicator
   * @review
   */

  var ChangeListsIndicator =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(ChangeListsIndicator, _PortletBase);

    function ChangeListsIndicator() {
      _classCallCheck(this, ChangeListsIndicator);

      return _possibleConstructorReturn(this, _getPrototypeOf(ChangeListsIndicator).apply(this, arguments));
    }

    _createClass(ChangeListsIndicator, [{
      key: "created",

      /**
       * @inheritDoc
       */
      value: function created() {
        this._eventHandler = new _metalEvents.EventHandler();
        var urlActiveCollection = this.urlCollectionsBase + '?companyId=' + Liferay.ThemeDisplay.getCompanyId() + '&userId=' + Liferay.ThemeDisplay.getUserId() + '&type=active';

        this._render(urlActiveCollection);

        var instance = this;
        Liferay.on('refreshChangeTrackingIndicator', function () {
          instance._render(urlActiveCollection);
        });
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        this._eventHandler.removeAllListeners();
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "disposed",
      value: function disposed() {
        this._eventHandler.removeAllListeners();
      }
      /**
       * Check element in document.
       * @memberof ChangeListsIndicator
       * @param selector
       * @private
       */

    }, {
      key: "_checkElement",
      value: function _checkElement(selector) {
        var _this = this;

        var element = document.querySelector(selector);
        var result = Promise.resolve(element);

        if (element === null) {
          result = this._rafAsync().then(function () {
            return _this._checkElement(selector);
          });
        }

        return result;
      }
      /**
       * Add tooltip css class.
       * @memberof ChangeListsIndicator
       * @param cssClassName
       * @private
       */

    }, {
      key: "_addTooltipCssClass",
      value: function _addTooltipCssClass(cssClassName) {
        this._checkElement(TOOLTIP_QUERY_SELECTOR).then(function (element) {
          if (element && !element.classList.contains(cssClassName)) {
            element.classList.add(cssClassName);
          }
        });
      }
      /**
       * Check element opacity.
       * @memberof ChangeListsIndicator
       * @param selector
       * @private
       */

    }, {
      key: "_checkElementHidden",
      value: function _checkElementHidden(selector) {
        var _this2 = this;

        var element = document.querySelector(selector);
        var result = Promise.resolve(element);

        if (element && this._getStyle(element, 'display') != 'none') {
          result = this._rafAsync().then(function () {
            return _this2._checkElementHidden(selector);
          });
        }

        return result;
      }
      /**
       * Handles mouseenter event.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_getDataRequest",
      value: function _getDataRequest(url, callback) {
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var type = 'GET';
        var init = {
          credentials: 'include',
          headers: headers,
          method: type
        };
        fetch(url, init).then(function (response) {
          return response.json();
        }).then(function (response) {
          return callback(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Language.get('an-error-occured-while-getting-the-active-change-list');
          (0, _frontendJsWeb.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
      /**
       * Get style of the element.
       * @memberof ChangeListsIndicator
       * @param element, property
       * @private
       */

    }, {
      key: "_getStyle",
      value: function _getStyle(element, property) {
        var result = null;

        if (element && element.currentStyle) {
          result = element.currentStyle[property];
        } else if (window.getComputedStyle) {
          result = window.getComputedStyle(element, null).getPropertyValue(property);
        }

        return result;
      }
      /**
       * Handles change list indicator blur event.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleChangeListIndicatorBlur",
      value: function _handleChangeListIndicatorBlur(event) {
        this._handleChangeListIndicatorMouseLeave.bind(this);
      }
      /**
       * Handles change list indicator focus event.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleChangeListIndicatorFocus",
      value: function _handleChangeListIndicatorFocus(event) {
        this._handleChangeListIndicatorMouseEnter.bind(this);
      }
      /**
       * Handles change list indicator click event.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleChangeListIndicatorMouseClick",
      value: function _handleChangeListIndicatorMouseClick(event) {
        this._handleChangeListIndicatorMouseEnter.bind(this);
      }
      /**
       * Handles change list indicator mouseenter event.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleChangeListIndicatorMouseEnter",
      value: function _handleChangeListIndicatorMouseEnter(event) {
        this._addTooltipCssClass(this._tooltipCssClassName);
      }
      /**
       * Handles change list indicator mouseleave events.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleChangeListIndicatorMouseLeave",
      value: function _handleChangeListIndicatorMouseLeave(event) {
        this._removeTooltipCssClass(this._tooltipCssClassName);
      }
      /**
       * Handles tooltip mouseleave events.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleTooltipMouseLeave",
      value: function _handleTooltipMouseLeave(event) {
        this._removeTooltipCssClass(this._tooltipCssClassName);
      }
      /**
       * Async requestAnimationFrame returning Promise.
       * @memberof ChangeListsIndicator
       * @param
       * @private
       */

    }, {
      key: "_rafAsync",
      value: function _rafAsync() {
        return new Promise(function (resolve) {
          requestAnimationFrame(resolve);
        });
      }
      /**
       * Remove tooltip css class.
       * @memberof ChangeListsIndicator
       * @param cssClassName
       * @private
       */

    }, {
      key: "_removeTooltipCssClass",
      value: function _removeTooltipCssClass(cssClassName) {
        this._checkElementHidden(TOOLTIP_QUERY_SELECTOR).then(function (element) {
          if (element && element.classList.contains(cssClassName)) {
            element.classList.remove(cssClassName);
          }
        });
      }
      /**
       * Rerenders the screen.
       * @param urlActiveCollection
       * @private
       */

    }, {
      key: "_render",
      value: function _render(urlActiveCollection) {
        var _this3 = this;

        this._getDataRequest(urlActiveCollection, function (response) {
          if (response) {
            _this3.activeChangeListId = response[0].ctCollectionId;
            _this3.activeChangeListName = response[0].name;

            _this3._setTooltipCssClassName(_this3.activeChangeListId);

            _this3._setEventHandlers();
          }
        });
      }
      /**
       * Set the event handlers for the change lists indicator.
       * @memberof ChangeListsIndicator
       * @param selector
       * @private
       */

    }, {
      key: "_setChangeListIndicatorEventHandler",
      value: function _setChangeListIndicatorEventHandler(selector) {
        this._eventHandler.add(_metalDom.dom.delegate(document, 'blur', selector, this._handleChangeListIndicatorBlur.bind(this)), _metalDom.dom.delegate(document, 'click', selector, this._handleChangeListIndicatorMouseClick.bind(this)), _metalDom.dom.delegate(document, 'focus', selector, this._handleChangeListIndicatorFocus.bind(this)), _metalDom.dom.delegate(document, 'mouseenter', selector, this._handleChangeListIndicatorMouseEnter.bind(this)), _metalDom.dom.delegate(document, 'mouseleave', selector, this._handleChangeListIndicatorMouseLeave.bind(this)));
      }
      /**
       * Set the event handlers.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_setEventHandlers",
      value: function _setEventHandlers() {
        this._setChangeListIndicatorEventHandler(CHANGE_LISTS_INDICATOR_QUERY_SELECTOR);

        this._seTooltipEventHandlers(TOOLTIP_QUERY_SELECTOR);
      }
      /**
       * Set the tooltip css class name.
       * @memberof ChangeListsIndicator
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_setTooltipCssClassName",
      value: function _setTooltipCssClassName(activeChangeListId) {
        this._tooltipCssClassName = activeChangeListId !== PRODUCTION_COLLECTION_ID ? BLUE_BACKGROUND_TOOLTIP_CSS_CLASS_NAME : GREEN_BACKGROUND_TOOLTIP_CSS_CLASS_NAME;
      }
      /**
       * Set the event handlers for the tooltip.
       * @memberof ChangeListsIndicator
       * @param selector
       * @private
       */

    }, {
      key: "_seTooltipEventHandlers",
      value: function _seTooltipEventHandlers(selector) {
        this._eventHandler.add(_metalDom.dom.delegate(document, 'mouseleave', selector, this._handleTooltipMouseLeave.bind(this)));
      }
    }]);

    return ChangeListsIndicator;
  }(_frontendJsWeb.PortletBase);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  ChangeListsIndicator.STATE = {
    /**
     * Name of the tooltip css class.
     * @default
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {!string}
     */
    _tooltipCssClassName: _metalState.Config.string().value(''),

    /**
     * Id of the active change list.
     * @default
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {!string}
     */
    activeChangeListId: _metalState.Config.number(),

    /**
     * Name of the active change list.
     * @default
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {!string}
     */
    activeChangeListName: _metalState.Config.string().value(''),

    /**
     * Id of production collection.
     * @default
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {!string}
     */
    productionCollectionId: _metalState.Config.number().value(PRODUCTION_COLLECTION_ID),

    /**
     * Path of the available icons.
     * @default undefined
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Base REST API URL to collection resource
     * @default
     * @instance
     * @memberOf ChangeListsIndicator
     * @review
     * @type {string}
     */
    urlCollectionsBase: _metalState.Config.string()
  };

  _metalSoy.default.register(ChangeListsIndicator, _ChangeListsIndicator.default);

  var _default = ChangeListsIndicator;
  exports.default = _default;
  //# sourceMappingURL=ChangeListsIndicator.es.js.map
});
//# sourceMappingURL=ChangeListsIndicator.es.js.map