"use strict";

Liferay.Loader.define("change-tracking-change-lists-configuration-web@1.0.11/js/ChangeListsConfiguration.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-navigation-bar', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', 'frontend-js-web/liferay/toast/commands/OpenToast.es', './ChangeListsConfiguration.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = void 0;

  var _clayNavigationBar = _interopRequireDefault(require("frontend-taglib-clay$clay-navigation-bar"));

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _OpenToast = require("frontend-js-web/liferay/toast/commands/OpenToast.es");

  var _ChangeListsConfiguration = _interopRequireDefault(require("./ChangeListsConfiguration.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Provides the component for the Change Lists configuration screen.
   */
  var ChangeListsConfiguration =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(ChangeListsConfiguration, _PortletBase);

    function ChangeListsConfiguration() {
      _classCallCheck(this, ChangeListsConfiguration);

      return _possibleConstructorReturn(this, _getPrototypeOf(ChangeListsConfiguration).apply(this, arguments));
    }

    _createClass(ChangeListsConfiguration, [{
      key: "created",
      value: function created() {
        var _this = this;

        this._getDataRequest(this.urlChangeTrackingConfiguration, function (response) {
          if (response) {
            _this.changeTrackingAllowed = response.changeTrackingAllowed;
            _this.changeTrackingEnabled = response.changeTrackingEnabled;
            _this.currentPage = 'Global Settings';
            _this.initialFetch = true;
            _this.tooltipBody = '';

            if (_this.changeTrackingEnabled) {
              _this.userSettingsEnabled = true;
            }

            response.supportedContentTypes.forEach(function (supportedContentType) {
              if (_this.tooltipBody.length > 0) {
                _this.tooltipBody = _this.tooltipBody.concat(' ');
              }

              _this.tooltipBody = _this.tooltipBody.concat(supportedContentType);
            });
          }
        });

        this._getDataRequest(this.urlChangeTrackingUserConfiguration, function (response) {
          if (response) {
            _this.checkoutCTCollectionConfirmationEnabled = response.checkoutCTCollectionConfirmationEnabled;
          }
        });
      }
      /**
       * Handles the toggle change.
       *
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleCheck",
      value: function _handleCheck(event) {
        this.changeTrackingEnabled = event.target.checked;
      }
      /**
       * Handles navigation click.
       *
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleNavItemClicked",
      value: function _handleNavItemClicked(event) {
        var _this2 = this;

        this.currentPage = event.data.item.label;
        this.navigationItems = this.navigationItems.map(function (item) {
          if (item.label === _this2.currentPage) {
            return Object.assign({}, item, {
              active: true
            });
          }

          return Object.assign({}, item, {
            active: false
          });
        });
      }
    }, {
      key: "_handleUserConfigCheck",
      value: function _handleUserConfigCheck(event) {
        this.checkoutCTCollectionConfirmationEnabled = event.target.checked;
      }
    }, {
      key: "_handleUserConfigSave",
      value: function _handleUserConfigSave(event) {
        event.preventDefault();
        var data = {
          checkoutCTCollectionConfirmationEnabled: this.checkoutCTCollectionConfirmationEnabled
        };

        this._putDataRequest(this.urlChangeTrackingUserConfiguration, data, function (response) {
          if (response) {
            var message = Liferay.Language.get('the-configuration-has-been-saved');
            (0, _OpenToast.openToast)({
              message: message,
              title: Liferay.Language.get('success'),
              type: 'success'
            });
          }
        });
      }
      /**
       * Saves the configuration.
       *
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleSave",
      value: function _handleSave(event) {
        var _this3 = this;

        event.preventDefault();
        var data = {
          changeTrackingEnabled: this.changeTrackingEnabled
        };

        this._putDataRequest(this.urlChangeTrackingConfiguration, data, function (response) {
          Liferay.Util.navigate(_this3.urlConfiguration);
        });
      }
      /**
       * Saves the configuration and redirects the user to the overview screen.
       *
       * @param {!Event} event
       * @private
       */

    }, {
      key: "_handleSaveAndGoToOverview",
      value: function _handleSaveAndGoToOverview(event) {
        var _this4 = this;

        var data = {
          changeTrackingEnabled: this.changeTrackingEnabled
        };

        this._putDataRequest(this.urlChangeTrackingConfiguration, data, function (response) {
          if (response) {
            var message = Liferay.Language.get('the-configuration-has-been-saved');
            (0, _OpenToast.openToast)({
              message: message,
              title: Liferay.Language.get('success'),
              type: 'success'
            });
            Liferay.Util.navigate(_this4.urlOverview);
          }
        });
      }
    }, {
      key: "_getDataRequest",
      value: function _getDataRequest(url, callback) {
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var request = {
          credentials: 'include',
          headers: headers,
          method: 'GET'
        };
        fetch(url, request).then(function (response) {
          return response.json();
        }).then(function (response) {
          return callback(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Language.get('an-error-occured-while-saving-configuration');
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }, {
      key: "_putDataRequest",
      value: function _putDataRequest(url, bodyData, callback) {
        var body = JSON.stringify(bodyData);
        var headers = new Headers();
        headers.append('Content-Type', 'application/json');
        headers.append('X-CSRF-Token', Liferay.authToken);
        var request = {
          body: body,
          credentials: 'include',
          headers: headers,
          method: 'PUT'
        };
        fetch(url, request).then(function (response) {
          return response.json();
        }).then(function (response) {
          return callback(response);
        }).catch(function (error) {
          var message = typeof error === 'string' ? error : Liferay.Language.get('an-error-occured-while-saving-configuration');
          (0, _OpenToast.openToast)({
            message: message,
            title: Liferay.Language.get('error'),
            type: 'danger'
          });
        });
      }
    }]);

    return ChangeListsConfiguration;
  }(_PortletBase2.default);
  /**
   * State definition.
   *
   * @static
   * @type {!Object}
   */

  ChangeListsConfiguration.STATE = {
    /**
     * If <code>true</code>, change tracking is allowed.
     *
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {boolean}
     */
    changeTrackingAllowed: _metalState.Config.bool(),

    /**
     * If <code>true</code>, change tracking is enabled.
     *
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {boolean}
     */
    changeTrackingEnabled: _metalState.Config.bool(),

    /**
     * If <code>true</code>, checkout change tracking confirmation is enabled.
     *
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {boolean}
     */
    checkoutCTCollectionConfirmationEnabled: _metalState.Config.bool(),

    /**
     * sets which page to display based on navigationItems
     *
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {string}
     */
    currentPage: _metalState.Config.string().value('Global Settings'),

    /**
     * If <code>true</code>, an initial fetch has already occurred.
     *
     * @default false
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {boolean}
     */
    initialFetch: _metalState.Config.bool().value(false),

    /**
     * Itemlist for navigationBar
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!array}
     */
    navigationItem: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      active: _metalState.Config.bool().value(false),
      href: _metalState.Config.string(),
      label: _metalState.Config.string().required()
    })).required(),

    /**
     * Itemlist for navigationBar
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!array}
     */
    navigationItems: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
      active: _metalState.Config.bool().value(false),
      href: _metalState.Config.string(),
      label: _metalState.Config.string().required()
    })).required(),

    /**
     * If <code>true</code>, User Settings is available in navigation.
     *
     * @default false
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {boolean}
     */
    userSettingsEnabled: _metalState.Config.bool().value(false),

    /**
     * URL for the REST service to the change tracking configuration endpoint.
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!string}
     */
    urlChangeTrackingConfiguration: _metalState.Config.string().required(),

    /**
     * URL for the REST service to the change tracking user configuration endpoint.
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!string}
     */
    urlChangeTrackingUserConfiguration: _metalState.Config.string().required(),

    /**
     * URL for the Overview screen.
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!string}
     */
    urlOverview: _metalState.Config.string().required(),

    /**
     * URL for the Configuration screen.
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!string}
     */
    urlConfiguration: _metalState.Config.string().required(),

    /**
     * Path of the available icons.
     *
     * @default undefined
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {!string}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Content types that support change tracking.
     *
     * @instance
     * @memberOf ChangeListsConfiguration
     * @type {string}
     */
    tooltipBody: _metalState.Config.string()
  };

  _metalSoy.default.register(ChangeListsConfiguration, _ChangeListsConfiguration.default);

  var _default = ChangeListsConfiguration;
  exports.default = _default;
  //# sourceMappingURL=ChangeListsConfiguration.es.js.map
});
//# sourceMappingURL=ChangeListsConfiguration.es.js.map