/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.configuration;

import com.liferay.change.tracking.configuration.CTConfiguration;
import com.liferay.change.tracking.configuration.CTConfigurationRegistry;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class CTConfigurationRegistryUtil {
    private static final ServiceTracker<CTConfigurationRegistry, CTConfigurationRegistry> _serviceTracker;

    public static List<String> getContentTypeLanguageKeys() {
        ArrayList<String> contentTypeLanguageKeys = new ArrayList<String>();
        List<CTConfiguration<?, ?>> ctConfigurations = CTConfigurationRegistryUtil._getCTConfigurationRegistry().getAllCTConfigurations();
        for (CTConfiguration<?, ?> ctConfiguration : ctConfigurations) {
            contentTypeLanguageKeys.add(ctConfiguration.getContentTypeLanguageKey());
        }
        return contentTypeLanguageKeys;
    }

    public static String getVersionEntityContentTypeLanguageKey(long classNameId) {
        CTConfiguration<?, ?> ctConfiguration = CTConfigurationRegistryUtil._getCTConfiguration(classNameId);
        return ctConfiguration.getContentTypeLanguageKey();
    }

    public static long getVersionEntityGroupId(long classNameId, long classPK) {
        CTConfiguration<?, ?> ctConfiguration = CTConfigurationRegistryUtil._getCTConfiguration(classNameId);
        Function<Long, ?> versionEntityByVersionEntityIdFunction = ctConfiguration.getVersionEntityByVersionEntityIdFunction();
        Object versionEntity = versionEntityByVersionEntityIdFunction.apply(classPK);
        if (versionEntity instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)versionEntity;
            return groupedModel.getGroupId();
        }
        return BeanPropertiesUtil.getLongSilent(versionEntity, (String)"groupId");
    }

    public static String getVersionEntitySiteName(long classNameId, long classPK) {
        CTConfiguration<?, ?> ctConfiguration = CTConfigurationRegistryUtil._getCTConfiguration(classNameId);
        Function<Long, ?> versionEntityByVersionEntityIdFunction = ctConfiguration.getVersionEntityByVersionEntityIdFunction();
        Function<?, String> versionEntitySiteNameFunction = ctConfiguration.getVersionEntitySiteNameFunction();
        return versionEntitySiteNameFunction.compose(versionEntityByVersionEntityIdFunction).apply(classPK);
    }

    public static String getVersionEntityTitle(long classNameId, long classPK) {
        CTConfiguration<?, ?> ctConfiguration = CTConfigurationRegistryUtil._getCTConfiguration(classNameId);
        Function<Long, ?> versionEntityByVersionEntityIdFunction = ctConfiguration.getVersionEntityByVersionEntityIdFunction();
        Function<?, String> versionEntityTitleFunction = ctConfiguration.getVersionEntityTitleFunction();
        return versionEntityTitleFunction.compose(versionEntityByVersionEntityIdFunction).apply(classPK);
    }

    public static Serializable getVersionEntityVersion(long classNameId, long classPK) {
        CTConfiguration<?, ?> ctConfiguration = CTConfigurationRegistryUtil._getCTConfiguration(classNameId);
        Function<Long, ?> versionEntityByVersionEntityIdFunction = ctConfiguration.getVersionEntityByVersionEntityIdFunction();
        Function<?, Serializable> versionEntityVersionFunction = ctConfiguration.getVersionEntityVersionFunction();
        return versionEntityVersionFunction.compose(versionEntityByVersionEntityIdFunction).apply(classPK);
    }

    private static CTConfiguration<?, ?> _getCTConfiguration(long classNameId) {
        Optional<CTConfiguration<?, ?>> ctConfigurationOptional = CTConfigurationRegistryUtil._getCTConfigurationRegistry().getCTConfigurationOptionalByVersionClassName(PortalUtil.getClassName((long)classNameId));
        return ctConfigurationOptional.get();
    }

    private static CTConfigurationRegistry _getCTConfigurationRegistry() {
        return (CTConfigurationRegistry)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CTConfigurationRegistry.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), CTConfigurationRegistry.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

