/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.change.tracking.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTProcess service. Represents a row in the &quot;CTProcess&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.model.impl.CTProcessModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.model.impl.CTProcessImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTProcess
 * @generated
 */
@ProviderType
public interface CTProcessModel extends BaseModel<CTProcess>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ct process model instance should use the {@link CTProcess} interface instead.
	 */

	/**
	 * Returns the primary key of this ct process.
	 *
	 * @return the primary key of this ct process
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ct process.
	 *
	 * @param primaryKey the primary key of this ct process
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the ct process ID of this ct process.
	 *
	 * @return the ct process ID of this ct process
	 */
	public long getCtProcessId();

	/**
	 * Sets the ct process ID of this ct process.
	 *
	 * @param ctProcessId the ct process ID of this ct process
	 */
	public void setCtProcessId(long ctProcessId);

	/**
	 * Returns the company ID of this ct process.
	 *
	 * @return the company ID of this ct process
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ct process.
	 *
	 * @param companyId the company ID of this ct process
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this ct process.
	 *
	 * @return the user ID of this ct process
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this ct process.
	 *
	 * @param userId the user ID of this ct process
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this ct process.
	 *
	 * @return the user uuid of this ct process
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this ct process.
	 *
	 * @param userUuid the user uuid of this ct process
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this ct process.
	 *
	 * @return the create date of this ct process
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this ct process.
	 *
	 * @param createDate the create date of this ct process
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the ct collection ID of this ct process.
	 *
	 * @return the ct collection ID of this ct process
	 */
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this ct process.
	 *
	 * @param ctCollectionId the ct collection ID of this ct process
	 */
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the background task ID of this ct process.
	 *
	 * @return the background task ID of this ct process
	 */
	public long getBackgroundTaskId();

	/**
	 * Sets the background task ID of this ct process.
	 *
	 * @param backgroundTaskId the background task ID of this ct process
	 */
	public void setBackgroundTaskId(long backgroundTaskId);

}