/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.category.apio.internal.architect.router.base;

import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetEntryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.category.apio.internal.architect.form.NestedCategoryForm;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCategoryNestedCollectionRouter<T extends Identifier<Long>>
implements NestedCollectionRouter<AssetCategory, Long, CategoryIdentifier, Long, T> {
    @Reference
    protected AssetCategoryService assetCategoryService;
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected AssetEntryService assetEntryService;
    @Reference
    protected AssetVocabularyService assetVocabularyService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected GroupLocalService groupLocalService;

    protected AssetCategory addAssetCategory(long classPK, NestedCategoryForm nestedCategoryForm) throws PortalException {
        AssetVocabulary assetVocabulary = this.assetVocabularyService.getVocabulary(nestedCategoryForm.getVocabularyId());
        Group group = this.groupLocalService.getGroup(assetVocabulary.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
        long parentCategoryId = nestedCategoryForm.getParentCategoryId();
        AssetCategory assetCategory = this.assetCategoryService.addCategory(group.getGroupId(), parentCategoryId, nestedCategoryForm.getTitles(locale), nestedCategoryForm.getDescriptions(locale), assetVocabulary.getVocabularyId(), null, new ServiceContext());
        long resporcePrimKey = this.getResourcePrimKey(classPK);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(this.getClassName(), resporcePrimKey);
        long[] categoryIds = ArrayUtil.append((long[])assetEntry.getCategoryIds(), (long)assetCategory.getCategoryId());
        this.assetEntryService.updateEntry(assetEntry.getGroupId(), assetEntry.getCreateDate(), null, assetEntry.getClassName(), resporcePrimKey, assetEntry.getClassUuid(), assetEntry.getClassTypeId(), categoryIds, assetEntry.getTagNames(), assetEntry.isListable(), assetEntry.isVisible(), assetEntry.getStartDate(), assetEntry.getEndDate(), assetEntry.getPublishDate(), assetEntry.getExpirationDate(), assetEntry.getMimeType(), assetEntry.getTitle(), assetEntry.getDescription(), assetEntry.getSummary(), assetEntry.getUrl(), assetEntry.getLayoutUuid(), assetEntry.getHeight(), assetEntry.getWidth(), Double.valueOf(assetEntry.getPriority()));
        return assetCategory;
    }

    protected abstract String getClassName();

    protected PageItems<AssetCategory> getPageItems(Pagination pagination, long classPK) throws PortalException {
        long resporcePrimKey = this.getResourcePrimKey(classPK);
        long classNameId = this.classNameLocalService.getClassNameId(this.getClassName());
        List assetCategories = this.assetCategoryService.getCategories(classNameId, resporcePrimKey, pagination.getStartPosition(), pagination.getEndPosition());
        int count = this.assetCategoryService.getCategoriesCount(classNameId, resporcePrimKey);
        return new PageItems((Collection)assetCategories, count);
    }

    protected long getResourcePrimKey(long classPK) throws PortalException {
        return classPK;
    }
}

