/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.category.apio.internal.architect.resource;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.representor.Representor;
import com.liferay.apio.architect.resource.NestedCollectionResource;
import com.liferay.apio.architect.routes.ItemRoutes;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryModel;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.category.apio.internal.architect.form.CategoryForm;
import com.liferay.person.apio.architect.identifier.PersonIdentifier;
import com.liferay.portal.apio.idempotent.Idempotent;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.vocabulary.apio.architect.identifier.VocabularyIdentifier;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class CategoryNestedCollectionResource
implements NestedCollectionResource<AssetCategory, Long, CategoryIdentifier, Long, VocabularyIdentifier> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(model.class.name=com.liferay.asset.kernel.model.AssetCategory)")
    private HasPermission<Long> _hasPermission;

    public NestedCollectionRoutes<AssetCategory, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<AssetCategory, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addAssetCategory, this._hasPermission.forAddingIn(VocabularyIdentifier.class), CategoryForm::buildForm).build();
    }

    public String getName() {
        return "categories";
    }

    public ItemRoutes<AssetCategory, Long> itemRoutes(ItemRoutes.Builder<AssetCategory, Long> builder) {
        return builder.addGetter(this::_getAssetCategory).addUpdater(this::_updateAssetCategory, (arg_0, arg_1) -> this._hasPermission.forUpdating(arg_0, arg_1), CategoryForm::buildForm).addRemover(Idempotent.idempotent(arg_0 -> ((AssetCategoryService)this._assetCategoryService).deleteCategory(arg_0)), (arg_0, arg_1) -> this._hasPermission.forDeleting(arg_0, arg_1)).build();
    }

    public Representor<AssetCategory> representor(Representor.Builder<AssetCategory, Long> builder) {
        return (Representor)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)((Representor.FirstStep)builder.types("Category", new String[0]).identifier(AssetCategoryModel::getCategoryId).addBidirectionalModel("category", "subcategories", CategoryIdentifier.class, AssetCategoryModel::getParentCategoryId).addBidirectionalModel("vocabulary", "vocabularyCategories", VocabularyIdentifier.class, AssetCategoryModel::getVocabularyId).addDate("dateCreated", AssetCategoryModel::getCreateDate)).addDate("dateModified", AssetCategoryModel::getModifiedDate)).addDate("datePublished", AssetCategoryModel::getLastPublishDate)).addLinkedModel("author", PersonIdentifier.class, AssetCategoryModel::getUserId)).addLinkedModel("creator", PersonIdentifier.class, AssetCategoryModel::getUserId)).addLocalizedStringByLocale("description", AssetCategoryModel::getDescription)).addLocalizedStringByLocale("name", AssetCategoryModel::getTitle)).build();
    }

    private AssetCategory _addAssetCategory(long vocabularyId, CategoryForm categoryForm) throws PortalException {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(vocabularyId);
        Group group = this._groupLocalService.getGroup(assetVocabulary.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
        ServiceContext serviceContext = new ServiceContext();
        return this._assetCategoryService.addCategory(assetVocabulary.getGroupId(), 0L, categoryForm.getTitles(locale), categoryForm.getDescriptions(locale), vocabularyId, null, serviceContext);
    }

    private AssetCategory _getAssetCategory(long assetCategoryId) throws PortalException {
        return this._assetCategoryService.getCategory(assetCategoryId);
    }

    private PageItems<AssetCategory> _getPageItems(Pagination pagination, long assetVocabularyId) throws PortalException {
        AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(assetVocabularyId);
        List categories = this._assetCategoryService.getVocabularyRootCategories(assetVocabulary.getGroupId(), assetVocabularyId, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._assetCategoryService.getVocabularyRootCategoriesCount(assetVocabulary.getGroupId(), assetVocabularyId);
        return new PageItems((Collection)categories, count);
    }

    private AssetCategory _updateAssetCategory(long assetCategoryId, CategoryForm categoryForm) throws PortalException {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(assetCategoryId);
        Group group = this._groupLocalService.getGroup(assetCategory.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
        ServiceContext serviceContext = new ServiceContext();
        return this._assetCategoryService.updateCategory(assetCategoryId, assetCategory.getParentCategoryId(), categoryForm.getTitles(locale), categoryForm.getDescriptions(locale), assetCategory.getVocabularyId(), null, serviceContext);
    }
}

