/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.category.apio.internal.permission;

import com.liferay.apio.architect.alias.routes.permission.HasNestedAddingPermissionFunction;
import com.liferay.apio.architect.credentials.Credentials;
import com.liferay.apio.architect.identifier.Identifier;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.asset.kernel.service.AssetVocabularyService;
import com.liferay.blog.apio.architect.identifier.BlogPostingIdentifier;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.media.object.apio.architect.identifier.MediaObjectIdentifier;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.structured.content.apio.architect.identifier.StructuredContentIdentifier;
import com.liferay.vocabulary.apio.architect.identifier.VocabularyIdentifier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={HasPermission.class})
public class CategoryHasPermissionImpl
implements HasPermission<Long> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private AssetVocabularyService _assetVocabularyService;
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private ModelResourcePermission _blogsEntryModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.FileEntry)")
    private ModelResourcePermission _fileEntryModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission _journalArticleModelResourcePermission;

    public <S> HasNestedAddingPermissionFunction<S> forAddingIn(Class<? extends Identifier<S>> identifierClass) {
        if (identifierClass.equals(VocabularyIdentifier.class)) {
            return (credentials, vocabularyId) -> {
                AssetVocabulary assetVocabulary = this._assetVocabularyService.getVocabulary(((Long)vocabularyId).longValue());
                return AssetCategoryPermission.contains((PermissionChecker)((PermissionChecker)credentials.get()), (long)assetVocabulary.getGroupId(), (long)0L, (String)"ADD_CATEGORY");
            };
        }
        if (identifierClass.equals(CategoryIdentifier.class)) {
            return (credentials, parentCategoryId) -> {
                AssetCategory category = this._assetCategoryService.getCategory(((Long)parentCategoryId).longValue());
                return AssetCategoryPermission.contains((PermissionChecker)((PermissionChecker)credentials.get()), (long)category.getGroupId(), (long)((Long)parentCategoryId), (String)"ADD_CATEGORY");
            };
        }
        if (identifierClass.equals(BlogPostingIdentifier.class)) {
            return (credentials, blogsEntryId) -> this._blogsEntryModelResourcePermission.contains((PermissionChecker)credentials.get(), ((Long)blogsEntryId).longValue(), "UPDATE");
        }
        if (identifierClass.equals(MediaObjectIdentifier.class)) {
            return (credentials, fileEntryId) -> this._fileEntryModelResourcePermission.contains((PermissionChecker)credentials.get(), ((Long)fileEntryId).longValue(), "UPDATE");
        }
        if (identifierClass.equals(StructuredContentIdentifier.class)) {
            return (credentials, journalArticleId) -> this._journalArticleModelResourcePermission.contains((PermissionChecker)credentials.get(), ((Long)journalArticleId).longValue(), "UPDATE");
        }
        return (credentials, s) -> false;
    }

    public Boolean forDeleting(Credentials credentials, Long assetCategoryId) throws PortalException {
        return AssetCategoryPermission.contains((PermissionChecker)((PermissionChecker)credentials.get()), (long)assetCategoryId, (String)"DELETE");
    }

    public Boolean forUpdating(Credentials credentials, Long assetCategoryId) throws PortalException {
        return AssetCategoryPermission.contains((PermissionChecker)((PermissionChecker)credentials.get()), (long)assetCategoryId, (String)"UPDATE");
    }
}

