/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.category.apio.internal.architect.router;

import com.liferay.apio.architect.pagination.PageItems;
import com.liferay.apio.architect.pagination.Pagination;
import com.liferay.apio.architect.router.NestedCollectionRouter;
import com.liferay.apio.architect.routes.NestedCollectionRoutes;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.category.apio.architect.identifier.CategoryIdentifier;
import com.liferay.category.apio.internal.architect.form.CategoryForm;
import com.liferay.portal.apio.permission.HasPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={NestedCollectionRouter.class})
public class CategoryCategoryNestedCollectionRouter
implements NestedCollectionRouter<AssetCategory, Long, CategoryIdentifier, Long, CategoryIdentifier> {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(model.class.name=com.liferay.asset.kernel.model.AssetCategory)")
    private HasPermission<Long> _hasPermission;

    public NestedCollectionRoutes<AssetCategory, Long, Long> collectionRoutes(NestedCollectionRoutes.Builder<AssetCategory, Long, Long> builder) {
        return builder.addGetter(this::_getPageItems).addCreator(this::_addAssetCategory, this._hasPermission.forAddingIn(CategoryIdentifier.class), CategoryForm::buildForm).build();
    }

    private AssetCategory _addAssetCategory(long parentCategoryId, CategoryForm categoryForm) throws PortalException {
        AssetCategory assetCategory = this._assetCategoryService.getCategory(parentCategoryId);
        Group group = this._groupLocalService.getGroup(assetCategory.getGroupId());
        Locale locale = LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId());
        ServiceContext serviceContext = new ServiceContext();
        return this._assetCategoryService.addCategory(group.getGroupId(), parentCategoryId, categoryForm.getTitles(locale), categoryForm.getDescriptions(locale), assetCategory.getVocabularyId(), null, serviceContext);
    }

    private PageItems<AssetCategory> _getPageItems(Pagination pagination, long parentCategoryId) throws PortalException {
        List assetCategories = this._assetCategoryService.getChildCategories(parentCategoryId, pagination.getStartPosition(), pagination.getEndPosition(), null);
        int count = this._assetCategoryService.getChildCategoriesCount(parentCategoryId);
        return new PageItems((Collection)assetCategories, count);
    }
}

