/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.rest.internal.resource.v1_0;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.rest.internal.resource.v1_0.BaseCaptchaResourceImpl;
import com.liferay.captcha.rest.resource.v1_0.CaptchaResource;
import com.liferay.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.encryptor.EncryptorUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.servlet.filters.secure.NonceUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.ws.rs.ForbiddenException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/captcha.properties"}, scope=ServiceScope.PROTOTYPE, service={CaptchaResource.class})
public class CaptchaResourceImpl
extends BaseCaptchaResourceImpl {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public com.liferay.captcha.rest.dto.v1_0.Captcha getCaptchaChallenge() throws Exception {
        this._checkCaptchaConfiguration();
        Captcha kernelCaptcha = CaptchaUtil.getCaptcha();
        try (final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            final String expectedAnswer = kernelCaptcha.serveImage((OutputStream)byteArrayOutputStream);
            com.liferay.captcha.rest.dto.v1_0.Captcha captcha = new com.liferay.captcha.rest.dto.v1_0.Captcha(){
                {
                    this.setImage(() -> {
                        String data = Base64.encode((byte[])byteArrayOutputStream.toByteArray());
                        return "data:image/png;base64," + data;
                    });
                    this.setToken(() -> EncryptorUtil.encrypt((Key)CaptchaResourceImpl.this.contextCompany.getKeyObj(), (String)JSONUtil.put((String)"answer", (Object)expectedAnswer).put("expiryTime", System.currentTimeMillis() + 300000L).put("nonce", NonceUtil.generate((long)CaptchaResourceImpl.this.contextCompany.getCompanyId(), (String)CaptchaResourceImpl.this.contextHttpServletRequest.getRemoteAddr())).toString()));
                }
            };
            return captcha;
        }
    }

    @Override
    public void postCaptchaResponse(com.liferay.captcha.rest.dto.v1_0.Captcha captcha) throws Exception {
        this._checkCaptchaConfiguration();
        JSONObject jsonObject = this._jsonFactory.createJSONObject(EncryptorUtil.decrypt((Key)this.contextCompany.getKeyObj(), (String)captcha.getToken()));
        if (!(jsonObject.has("answer") && jsonObject.has("expiryTime") && NonceUtil.verify((String)jsonObject.getString("nonce")))) {
            throw new IllegalArgumentException("Token: " + captcha.getToken());
        }
        long expiryTime = jsonObject.getLong("expiryTime");
        if (expiryTime < System.currentTimeMillis()) {
            throw new CaptchaTextException("Captcha is expired");
        }
        if (!StringUtil.equalsIgnoreCase((String)jsonObject.getString("answer"), (String)captcha.getAnswer())) {
            throw new CaptchaTextException("Answer is invalid");
        }
    }

    private void _checkCaptchaConfiguration() throws Exception {
        CaptchaConfiguration captchaConfiguration = (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        if (!StringUtil.equalsIgnoreCase((String)captchaConfiguration.captchaEngine(), (String)SimpleCaptchaImpl.class.getName())) {
            throw new ForbiddenException("Captcha engine is not configured to use SimpleCaptcha");
        }
    }
}

