/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.internal.provider;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.provider.CaptchaProvider;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.captcha.Captcha;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.captcha.configuration.CaptchaConfiguration"}, service={CaptchaProvider.class})
public class CaptchaProviderImpl
implements CaptchaProvider {
    private volatile CaptchaConfiguration _captchaConfiguration;
    private ServiceTrackerMap<String, Captcha> _serviceTrackerMap;

    public Captcha getCaptcha() {
        String captchaClassName = this._captchaConfiguration.captchaEngine();
        return (Captcha)this._serviceTrackerMap.getService((Object)captchaClassName);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.modified(properties);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Captcha.class, (String)"captcha.engine.impl");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        this._captchaConfiguration = (CaptchaConfiguration)ConfigurableUtil.createConfigurable(CaptchaConfiguration.class, properties);
    }
}

