/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.gimpy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import nl.captcha.gimpy.GimpyRenderer;

public class FishEyeGimpyRenderer
implements GimpyRenderer {
    private final Color _hColor;
    private final Color _vColor;

    public FishEyeGimpyRenderer() {
        this(Color.BLACK, Color.BLACK);
    }

    public FishEyeGimpyRenderer(Color color, Color color2) {
        this._hColor = color;
        this._vColor = color2;
    }

    public void gimp(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        int n4 = n2 / 7;
        int n5 = n3 / 7;
        int n6 = n2 / (n4 + 1);
        int n7 = n3 / (n5 + 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (n = n6; n < n2; n += n6) {
            graphics2D.setColor(this._hColor);
            graphics2D.drawLine(0, n, n3, n);
        }
        for (n = n7; n < n3; n += n7) {
            graphics2D.setColor(this._vColor);
            graphics2D.drawLine(n, 0, n, n2);
        }
        int[] nArray = new int[n2 * n3];
        int n8 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray[n8] = bufferedImage.getRGB(i, j);
                ++n8;
            }
        }
        double d = this.ranInt(n3 / 4, n3 / 3);
        int n9 = bufferedImage.getWidth() / 2;
        int n10 = bufferedImage.getHeight() / 2;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                int n11 = i - n9;
                int n12 = j - n10;
                double d2 = Math.sqrt(n11 * n11 + n12 * n12);
                if (!(d2 < d)) continue;
                int n13 = n9 + (int)(this.fishEyeFormula(d2 / d) * d / d2 * (double)(i - n9));
                int n14 = n10 + (int)(this.fishEyeFormula(d2 / d) * d / d2 * (double)(j - n10));
                bufferedImage.setRGB(i, j, nArray[n13 * n2 + n14]);
            }
        }
        graphics2D.dispose();
    }

    private final int ranInt(int n, int n2) {
        double d = Math.random();
        return (int)((double)n + (double)(n2 - n + 1) * d);
    }

    private final double fishEyeFormula(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return d;
        }
        return -0.75 * d * d * d + 1.5 * d * d + 0.25 * d;
    }
}

