/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.util;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.captcha.configuration.CaptchaConfiguration"}, immediate=true, service={CaptchaUtil.class})
public class CaptchaUtil {
    private static volatile CaptchaConfiguration _captchaConfiguration;
    private static ConfigurationAdmin _configurationAdmin;
    private static ServiceTrackerMap<String, Captcha> _serviceTrackerMap;

    public static void check(HttpServletRequest request) throws CaptchaException {
        CaptchaUtil.getCaptcha().check(request);
    }

    public static void check(PortletRequest portletRequest) throws CaptchaException {
        CaptchaUtil.getCaptcha().check(portletRequest);
    }

    public static Captcha getCaptcha() {
        String captchaClassName = _captchaConfiguration.captchaEngine();
        return (Captcha)_serviceTrackerMap.getService((Object)captchaClassName);
    }

    public static String getTaglibPath() {
        return CaptchaUtil.getCaptcha().getTaglibPath();
    }

    public static boolean isEnabled(HttpServletRequest request) {
        return CaptchaUtil.getCaptcha().isEnabled(request);
    }

    public static boolean isEnabled(PortletRequest portletRequest) {
        return CaptchaUtil.getCaptcha().isEnabled(portletRequest);
    }

    public static void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.getCaptcha().serveImage(request, response);
    }

    public static void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        CaptchaUtil.getCaptcha().serveImage(resourceRequest, resourceResponse);
    }

    public static void setCaptcha(Captcha captcha) throws Exception {
        Configuration configuration = _configurationAdmin.getConfiguration(CaptchaConfiguration.class.getName(), "?");
        Hashtable<String, String> properties = configuration.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, String>();
        }
        Class<?> clazz = captcha.getClass();
        ((Dictionary)properties).put("captchaEngine", clazz.getName());
        configuration.update(properties);
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        _captchaConfiguration = (CaptchaConfiguration)ConfigurableUtil.createConfigurable(CaptchaConfiguration.class, properties);
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Captcha.class, (String)"captcha.engine.impl");
    }

    @Deactivate
    protected void deactivate() {
        _serviceTrackerMap.close();
        _serviceTrackerMap = null;
    }

    @Reference(unbind="-")
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        _configurationAdmin = configurationAdmin;
    }
}

