/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.calendar.model.CalendarBooking;
import com.liferay.calendar.service.CalendarBookingLocalService;
import com.liferay.calendar.uad.constants.CalendarUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCalendarBookingUADAnonymizer
extends DynamicQueryUADAnonymizer<CalendarBooking> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected CalendarBookingLocalService calendarBookingLocalService;

    public void autoAnonymize(CalendarBooking calendarBooking, long userId, User anonymousUser) throws PortalException {
        if (calendarBooking.getUserId() == userId) {
            calendarBooking.setUserId(anonymousUser.getUserId());
            calendarBooking.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(calendarBooking, anonymousUser);
        }
        if (calendarBooking.getStatusByUserId() == userId) {
            calendarBooking.setStatusByUserId(anonymousUser.getUserId());
            calendarBooking.setStatusByUserName(anonymousUser.getFullName());
        }
        this.calendarBookingLocalService.updateCalendarBooking(calendarBooking);
    }

    public void delete(CalendarBooking calendarBooking) throws PortalException {
        this.calendarBookingLocalService.deleteCalendarBooking(calendarBooking);
    }

    public Class<CalendarBooking> getTypeClass() {
        return CalendarBooking.class;
    }

    protected void autoAnonymizeAssetEntry(CalendarBooking calendarBooking, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(calendarBooking);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.calendarBookingLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return CalendarUADConstants.USER_ID_FIELD_NAMES_CALENDAR_BOOKING;
    }

    protected AssetEntry fetchAssetEntry(CalendarBooking calendarBooking) {
        return this.assetEntryLocalService.fetchEntry(CalendarBooking.class.getName(), calendarBooking.getCalendarBookingId());
    }
}

