/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.exporter;

import com.liferay.calendar.exporter.CalendarDataFormat;
import com.liferay.calendar.exporter.CalendarDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CalendarDataHandlerFactory {
    private static final Map<CalendarDataFormat, CalendarDataHandler> _calendarDataHandlers = new ConcurrentHashMap<CalendarDataFormat, CalendarDataHandler>();

    public static CalendarDataHandler getCalendarDataHandler(CalendarDataFormat calendarDataFormat) throws PortalException {
        CalendarDataHandler calendarDataHandler = _calendarDataHandlers.get((Object)calendarDataFormat);
        if (calendarDataHandler == null) {
            throw new PortalException("Invalid format type " + (Object)((Object)calendarDataFormat));
        }
        return calendarDataHandler;
    }

    public static void registerCalendarDataHandler(CalendarDataFormat calendarDataFormat, CalendarDataHandler calendarDataHandler) {
        _calendarDataHandlers.put(calendarDataFormat, calendarDataHandler);
    }

    public static void unregisterCalendarDataHandler(CalendarDataFormat calendarDataFormat) {
        _calendarDataHandlers.remove((Object)calendarDataFormat);
    }
}

