/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.exporter;

import com.liferay.calendar.exporter.CalendarDataFormat;
import com.liferay.calendar.exporter.CalendarDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.HashMap;
import java.util.Map;

public class CalendarDataHandlerFactory {
    private static Map<CalendarDataFormat, CalendarDataHandler> _calendarDataHandlers;

    public static CalendarDataHandler getCalendarDataHandler(CalendarDataFormat calendarDataFormat) throws PortalException {
        CalendarDataHandler calendarDataHandler = _calendarDataHandlers.get((Object)calendarDataFormat);
        if (calendarDataHandler == null) {
            throw new PortalException("Invalid format type " + (Object)((Object)calendarDataFormat));
        }
        return calendarDataHandler;
    }

    public void setCalendarDataHandlers(Map<String, CalendarDataHandler> calendarDataHandlers) {
        _calendarDataHandlers = new HashMap<CalendarDataFormat, CalendarDataHandler>();
        for (Map.Entry<String, CalendarDataHandler> entry : calendarDataHandlers.entrySet()) {
            CalendarDataFormat calendarDataFormat = CalendarDataFormat.parse(entry.getKey());
            _calendarDataHandlers.put(calendarDataFormat, entry.getValue());
        }
    }
}

