/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.calendar.service;

import aQute.bnd.annotation.ProviderType;

import com.liferay.calendar.model.Calendar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Provides the remote service interface for Calendar. Methods of this
 * service are expected to have security checks based on the propagated JAAS
 * credentials because this service can be accessed remotely.
 *
 * @author Eduardo Lundgren
 * @see CalendarServiceUtil
 * @see com.liferay.calendar.service.base.CalendarServiceBaseImpl
 * @see com.liferay.calendar.service.impl.CalendarServiceImpl
 * @generated
 */
@AccessControlled
@JSONWebService
@OSGiBeanProperties(property =  {
	"json.web.service.context.name=calendar", "json.web.service.context.path=Calendar"}, service = CalendarService.class)
@ProviderType
@Transactional(isolation = Isolation.PORTAL, rollbackFor =  {
	PortalException.class, SystemException.class})
public interface CalendarService extends BaseService {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link CalendarServiceUtil} to access the calendar remote service. Add custom service methods to {@link com.liferay.calendar.service.impl.CalendarServiceImpl} and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public Calendar addCalendar(long groupId, long calendarResourceId,
		Map<Locale, String> nameMap, Map<Locale, String> descriptionMap,
		String timeZoneId, int color, boolean defaultCalendar,
		boolean enableComments, boolean enableRatings,
		ServiceContext serviceContext) throws PortalException;

	public Calendar deleteCalendar(long calendarId) throws PortalException;

	public String exportCalendar(long calendarId, String type)
		throws Exception;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public Calendar fetchCalendar(long calendarId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public Calendar getCalendar(long calendarId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> getCalendarResourceCalendars(long groupId,
		long calendarResourceId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> getCalendarResourceCalendars(long groupId,
		long calendarResourceId, boolean defaultCalendar)
		throws PortalException;

	/**
	* Returns the OSGi service identifier.
	*
	* @return the OSGi service identifier
	*/
	public String getOSGiServiceIdentifier();

	public void importCalendar(long calendarId, String data, String type)
		throws Exception;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean isManageableFromGroup(long calendarId, long groupId)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> search(long companyId, long[] groupIds,
		long[] calendarResourceIds, String keywords, boolean andOperator,
		int start, int end, OrderByComparator<Calendar> orderByComparator)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> search(long companyId, long[] groupIds,
		long[] calendarResourceIds, String keywords, boolean andOperator,
		int start, int end, OrderByComparator<Calendar> orderByComparator,
		String actionId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> search(long companyId, long[] groupIds,
		long[] calendarResourceIds, String name, String description,
		boolean andOperator, int start, int end,
		OrderByComparator<Calendar> orderByComparator)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<Calendar> search(long companyId, long[] groupIds,
		long[] calendarResourceIds, String name, String description,
		boolean andOperator, int start, int end,
		OrderByComparator<Calendar> orderByComparator, String actionId)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds,
		long[] calendarResourceIds, String keywords, boolean andOperator)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds,
		long[] calendarResourceIds, String keywords, boolean andOperator,
		String actionId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds,
		long[] calendarResourceIds, String name, String description,
		boolean andOperator) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds,
		long[] calendarResourceIds, String name, String description,
		boolean andOperator, String actionId) throws PortalException;

	public Calendar updateCalendar(long calendarId,
		Map<Locale, String> nameMap, Map<Locale, String> descriptionMap,
		int color, ServiceContext serviceContext) throws PortalException;

	public Calendar updateCalendar(long calendarId,
		Map<Locale, String> nameMap, Map<Locale, String> descriptionMap,
		String timeZoneId, int color, boolean defaultCalendar,
		boolean enableComments, boolean enableRatings,
		ServiceContext serviceContext) throws PortalException;

	public Calendar updateColor(long calendarId, int color,
		ServiceContext serviceContext) throws PortalException;
}