/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.Predicates;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;

class Filters {
    private static final int LOW_24_BITS = 0xFFFFFF;
    private static final long LOW_60_BITS = 0xFFFFFFFFFFFFFFFL;

    static Predicate<DateValue> byDayFilter(final WeekdayNum[] days, final boolean weeksInYear, final Weekday wkst) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                int instance;
                Weekday dow0;
                int nDays;
                Weekday dow = Weekday.valueOf(date);
                if (weeksInYear) {
                    nDays = TimeUtils.yearLength(date.year());
                    dow0 = Weekday.firstDayOfWeekInMonth(date.year(), 1);
                    instance = TimeUtils.dayOfYear(date.year(), date.month(), date.day());
                } else {
                    nDays = TimeUtils.monthLength(date.year(), date.month());
                    dow0 = Weekday.firstDayOfWeekInMonth(date.year(), date.month());
                    instance = date.day() - 1;
                }
                int dateWeekNo = wkst.javaDayNum <= dow.javaDayNum ? 1 + instance / 7 : instance / 7;
                int i = days.length;
                while (--i >= 0) {
                    WeekdayNum day = days[i];
                    if (day.wday != dow) continue;
                    int weekNo = day.num;
                    if (weekNo == 0) {
                        return true;
                    }
                    if (weekNo < 0) {
                        weekNo = Util.invertWeekdayNum(day, dow0, nDays);
                    }
                    if (dateWeekNo != weekNo) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> byMonthDayFilter(final int[] monthDays) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                int nDays = TimeUtils.monthLength(date.year(), date.month());
                int i = monthDays.length;
                while (--i >= 0) {
                    int day = monthDays[i];
                    if (day < 0) {
                        day += nDays + 1;
                    }
                    if (day != date.day()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> weekIntervalFilter(final int interval, Weekday wkst, DateValue dtStart) {
        return new Predicate<DateValue>(dtStart, wkst){
            DateValue wkStart;
            {
                DTBuilder wkStartB = new DTBuilder(dateValue);
                wkStartB.day -= (7 + Weekday.valueOf((DateValue)dateValue).javaDayNum - weekday.javaDayNum) % 7;
                this.wkStart = wkStartB.toDate();
            }

            @Override
            public boolean apply(DateValue date) {
                int off;
                int daysBetween = TimeUtils.daysBetween(date, this.wkStart);
                if (daysBetween < 0) {
                    daysBetween += interval * 7 * (1 + daysBetween / (-7 * interval));
                }
                return (off = daysBetween / 7 % interval) == 0;
            }
        };
    }

    static Predicate<DateValue> byHourFilter(int[] hours) {
        int hoursByBit = 0;
        int[] nArray = hours;
        int n = hours.length;
        int n2 = 0;
        while (n2 < n) {
            int hour = nArray[n2];
            hoursByBit |= 1 << hour;
            ++n2;
        }
        if ((hoursByBit & 0xFFFFFF) == 0xFFFFFF) {
            return Predicates.alwaysTrue();
        }
        final int bitField = hoursByBit;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1 << tv.hour()) != 0;
            }
        };
    }

    static Predicate<DateValue> byMinuteFilter(int[] minutes) {
        long minutesByBit = 0L;
        int[] nArray = minutes;
        int n = minutes.length;
        int n2 = 0;
        while (n2 < n) {
            int minute = nArray[n2];
            minutesByBit |= 1L << minute;
            ++n2;
        }
        if ((minutesByBit & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long bitField = minutesByBit;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1L << tv.minute()) != 0L;
            }
        };
    }

    static Predicate<DateValue> bySecondFilter(int[] seconds) {
        long secondsByBit = 0L;
        int[] nArray = seconds;
        int n = seconds.length;
        int n2 = 0;
        while (n2 < n) {
            int second = nArray[n2];
            secondsByBit |= 1L << second;
            ++n2;
        }
        if ((secondsByBit & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long bitField = secondsByBit;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue date) {
                if (!(date instanceof TimeValue)) {
                    return false;
                }
                TimeValue tv = (TimeValue)((Object)date);
                return (bitField & 1L << tv.second()) != 0L;
            }
        };
    }

    private Filters() {
    }
}

