/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bulk.selection.internal;

import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.bulk.selection.BulkSelectionFactoryRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={BulkSelectionFactoryRegistry.class})
public class BulkSelectionFactoryRegistryImpl
implements BulkSelectionFactoryRegistry {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    private ServiceTrackerMap<String, BulkSelectionFactory<?>> _serviceTrackerMap;

    public <T> BulkSelectionFactory<T> getBulkSelectionFactory(long classNameId) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        return this.getBulkSelectionFactory(className.getClassName());
    }

    public <T> BulkSelectionFactory<T> getBulkSelectionFactory(String className) {
        return (BulkSelectionFactory)this._serviceTrackerMap.getService((Object)className);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, BulkSelectionFactory.class, (String)"model.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

