/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.util;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class BookmarksUtil {
    public static String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.fetchBookmarksFolder((long)folderId);
        List folders = folder.getAncestors();
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        Collections.reverse(folders);
        for (BookmarksFolder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public static String getControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)portletRequest, (String)"com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", (String)"RENDER_PHASE");
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/bookmarks/view_folder");
            portletURL.setParameter("folderId", String.valueOf(folderId));
        }
        return portletURL.toString();
    }
}

