/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.trash;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.List;

public abstract class BookmarksBaseTrashHandler
extends BaseTrashHandler {
    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return BookmarksFolderLocalServiceUtil.getFolder((long)containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return BookmarksFolder.class.getName();
    }

    public List<ContainerModel> getContainerModels(long classPK, long parentContainerModelId, int start, int end) throws PortalException {
        List folders = BookmarksFolderLocalServiceUtil.getFolders((long)this.getGroupId(classPK), (long)parentContainerModelId, (int)start, (int)end);
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>(folders.size());
        for (BookmarksFolder curFolder : folders) {
            containerModels.add((ContainerModel)curFolder);
        }
        return containerModels;
    }

    public int getContainerModelsCount(long classPK, long parentContainerModelId) throws PortalException {
        return BookmarksFolderLocalServiceUtil.getFoldersCount((long)this.getGroupId(classPK), (long)parentContainerModelId);
    }

    public List<ContainerModel> getParentContainerModels(long classPK) throws PortalException {
        ArrayList<ContainerModel> containerModels = new ArrayList<ContainerModel>();
        ContainerModel containerModel = this.getParentContainerModel(classPK);
        if (containerModel == null) {
            return containerModels;
        }
        containerModels.add(containerModel);
        while (containerModel.getParentContainerModelId() > 0L && (containerModel = this.getContainerModel(containerModel.getParentContainerModelId())) != null) {
            containerModels.add(containerModel);
        }
        return containerModels;
    }

    public String getRootContainerModelName() {
        return "folder";
    }

    public String getSubcontainerModelName() {
        return "folder";
    }

    public String getTrashContainedModelName() {
        return "bookmarks";
    }

    public int getTrashContainedModelsCount(long classPK) throws PortalException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksEntryLocalServiceUtil.getEntriesCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public String getTrashContainerModelName() {
        return "folders";
    }

    public int getTrashContainerModelsCount(long classPK) throws PortalException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksFolderLocalServiceUtil.getFoldersCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public int getTrashModelsCount(long classPK) throws PortalException {
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        return BookmarksFolderLocalServiceUtil.getFoldersAndEntriesCount((long)folder.getGroupId(), (long)classPK, (int)8);
    }

    public List<TrashedModel> getTrashModelTrashedModels(long classPK, int start, int end, OrderByComparator obc) throws PortalException {
        ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
        List foldersAndEntries = BookmarksFolderLocalServiceUtil.getFoldersAndEntries((long)folder.getGroupId(), (long)classPK, (int)8, (int)start, (int)end, (OrderByComparator)obc);
        for (Object folderOrEntry : foldersAndEntries) {
            if (folderOrEntry instanceof BookmarksFolder) {
                BookmarksFolder curFolder = (BookmarksFolder)folderOrEntry;
                trashedModels.add((TrashedModel)curFolder);
                continue;
            }
            BookmarksEntry entry = (BookmarksEntry)folderOrEntry;
            trashedModels.add((TrashedModel)entry);
        }
        return trashedModels;
    }

    public boolean isMovable() {
        return true;
    }

    protected abstract long getGroupId(long var1) throws PortalException;
}

