/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.bookmarks.exception.EntryURLException;
import com.liferay.bookmarks.exception.NoSuchEntryException;
import com.liferay.bookmarks.exception.NoSuchFolderException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryService;
import com.liferay.bookmarks.service.BookmarksFolderService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.service.TrashEntryService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "mvc.command.name=/bookmarks/edit_entry", "mvc.command.name=/bookmarks/move_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private BookmarksEntryService _bookmarksEntryService;
    @Reference
    private BookmarksFolderService _bookmarksFolderService;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    @Reference
    private TrashEntryService _trashEntryService;

    protected void deleteEntry(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds;
        long[] deleteEntryIds = null;
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        deleteEntryIds = entryId > 0L ? new long[]{entryId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsBookmarksEntry");
        ArrayList<Object> trashedModels = new ArrayList<Object>();
        for (long deleteEntryId : deleteEntryIds) {
            if (moveToTrash) {
                BookmarksEntry entry = this._bookmarksEntryService.moveEntryToTrash(deleteEntryId);
                trashedModels.add(entry);
                continue;
            }
            this._bookmarksEntryService.deleteEntry(deleteEntryId);
        }
        for (long deleteFolderId : deleteFolderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsBookmarksFolder")) {
            if (moveToTrash) {
                BookmarksFolder folder = this._bookmarksFolderService.moveFolderToTrash(deleteFolderId);
                trashedModels.add(folder);
                continue;
            }
            this._bookmarksFolderService.deleteFolder(deleteFolderId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BookmarksEntry entry = null;
            if (cmd.equals("add") || cmd.equals("update")) {
                entry = this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest, false);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntry(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeEntry(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeEntry(actionRequest);
            }
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                if (cmd.equals("add") && entry != null) {
                    String portletId = this._http.getParameter(redirect, "portletResource", false);
                    String namespace = this._portal.getPortletNamespace(portletId);
                    if (Validator.isNotNull((String)portletId)) {
                        redirect = this._http.addParameter(redirect, namespace + "className", BookmarksEntry.class.getName());
                        redirect = this._http.addParameter(redirect, namespace + "classPK", entry.getEntryId());
                    }
                }
                actionRequest.setAttribute("REDIRECT", (Object)redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/bookmarks/error.jsp");
            }
            if (e instanceof EntryURLException || e instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long[] entryIds;
        long[] folderIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        for (long folderId : folderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsBookmarksFolder")) {
            this._bookmarksFolderService.moveFolder(folderId, newFolderId);
        }
        for (long entryId : entryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsBookmarksEntry")) {
            this._bookmarksEntryService.moveEntry(entryId, newFolderId);
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    protected void subscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        this._bookmarksEntryService.subscribeEntry(entryId);
    }

    protected void unsubscribeEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        this._bookmarksEntryService.unsubscribeEntry(entryId);
    }

    protected BookmarksEntry updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        BookmarksEntry entry = null;
        entry = entryId <= 0L ? this._bookmarksEntryService.addEntry(groupId, folderId, name, url, description, serviceContext) : this._bookmarksEntryService.updateEntry(entryId, groupId, folderId, name, url, description, serviceContext);
        return entry;
    }
}

