/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.bookmarks.exception.NoSuchEntryException;
import com.liferay.bookmarks.exception.NoSuchFolderException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryServiceUtil;
import com.liferay.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.bookmarks.web.internal.security.permission.resource.BookmarksResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static List<BookmarksEntry> getEntries(HttpServletRequest httpServletRequest) throws Exception {
        long[] entryIds = ParamUtil.getLongValues((HttpServletRequest)httpServletRequest, (String)"rowIdsBookmarksEntry");
        ArrayList<BookmarksEntry> entries = new ArrayList<BookmarksEntry>();
        for (long entryId : entryIds) {
            BookmarksEntry entry = BookmarksEntryServiceUtil.getEntry((long)entryId);
            entries.add(entry);
        }
        return entries;
    }

    public static List<BookmarksEntry> getEntries(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getEntries(httpServletRequest);
    }

    public static BookmarksEntry getEntry(HttpServletRequest httpServletRequest) throws Exception {
        long entryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"entryId");
        BookmarksEntry entry = null;
        if (entryId > 0L && (entry = BookmarksEntryServiceUtil.getEntry((long)entryId)).isInTrash()) {
            throw new NoSuchEntryException("{entryId=" + entryId + "}");
        }
        return entry;
    }

    public static BookmarksEntry getEntry(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getEntry(httpServletRequest);
    }

    public static BookmarksFolder getFolder(HttpServletRequest httpServletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"folderId");
        BookmarksFolder folder = null;
        if (folderId > 0L && folderId != 0L) {
            folder = BookmarksFolderServiceUtil.getFolder((long)folderId);
            if (folder.isInTrash()) {
                throw new NoSuchFolderException("{folderId=" + folderId + "}");
            }
        } else {
            BookmarksResourcePermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        }
        return folder;
    }

    public static BookmarksFolder getFolder(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolder(httpServletRequest);
    }

    public static List<BookmarksFolder> getFolders(HttpServletRequest httpServletRequest) throws Exception {
        long[] folderIds = ParamUtil.getLongValues((HttpServletRequest)httpServletRequest, (String)"rowIdsBookmarksFolder");
        ArrayList<BookmarksFolder> folders = new ArrayList<BookmarksFolder>();
        for (long folderId : folderIds) {
            if (folderId <= 0L || folderId == 0L) continue;
            BookmarksFolder folder = BookmarksFolderServiceUtil.getFolder((long)folderId);
            folders.add(folder);
        }
        return folders;
    }

    public static List<BookmarksFolder> getFolders(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolders(httpServletRequest);
    }
}

