/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.bookmarks.web.internal.asset.model.BookmarksFolderAssetRenderer;
import com.liferay.bookmarks.web.internal.asset.model.BookmarksRootFolderAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.trash.TrashHelper;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet"}, service={AssetRendererFactory.class})
public class BookmarksFolderAssetRendererFactory
extends BaseAssetRendererFactory<BookmarksFolder> {
    public static final String TYPE = "bookmark_folder";
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.bookmarks.web)")
    private ServletContext _servletContext;
    @Reference
    private TrashHelper _trashHelper;

    public BookmarksFolderAssetRendererFactory() {
        this.setCategorizable(false);
        this.setClassName(BookmarksFolder.class.getName());
        this.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
        this.setSearchable(true);
    }

    public AssetRenderer<BookmarksFolder> getAssetRenderer(long classPK, int type) throws PortalException {
        BookmarksFolder folder = this._bookmarksFolderLocalService.fetchBookmarksFolder(classPK);
        if (folder == null) {
            return new BookmarksRootFolderAssetRenderer(this._groupLocalService.getGroup(classPK));
        }
        BookmarksFolderAssetRenderer bookmarksFolderAssetRenderer = new BookmarksFolderAssetRenderer(folder, this._trashHelper, this._bookmarksFolderModelResourcePermission);
        bookmarksFolderAssetRenderer.setAssetRendererType(type);
        bookmarksFolderAssetRenderer.setServletContext(this._servletContext);
        return bookmarksFolderAssetRenderer;
    }

    public String getClassName() {
        return BookmarksFolder.class.getName();
    }

    public String getIconCssClass() {
        return "folder";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_bookmarks_web_portlet_BookmarksPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return this._bookmarksFolderModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }
}

