/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.web.internal.asset.model.BookmarksEntryAssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet"}, service={AssetRendererFactory.class})
public class BookmarksEntryAssetRendererFactory
extends BaseAssetRendererFactory<BookmarksEntry> {
    public static final String TYPE = "bookmark";
    @Reference
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private ModelResourcePermission<BookmarksEntry> _bookmarksEntryModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.bookmarks)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference(target="(osgi.web.symbolicname=com.liferay.bookmarks.web)")
    private ServletContext _servletContext;

    public BookmarksEntryAssetRendererFactory() {
        this.setClassName(BookmarksEntry.class.getName());
        this.setLinkable(true);
        this.setPortletId("com_liferay_bookmarks_web_portlet_BookmarksPortlet");
        this.setSearchable(true);
    }

    public AssetRenderer<BookmarksEntry> getAssetRenderer(long classPK, int type) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        BookmarksEntryAssetRenderer bookmarksEntryAssetRenderer = new BookmarksEntryAssetRenderer(entry, this._bookmarksEntryModelResourcePermission);
        bookmarksEntryAssetRenderer.setAssetRendererType(type);
        bookmarksEntryAssetRenderer.setServletContext(this._servletContext);
        return bookmarksEntryAssetRenderer;
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public String getIconCssClass() {
        return "bookmarks";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this.getGroup(liferayPortletRequest), "com_liferay_bookmarks_web_portlet_BookmarksPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/bookmarks/edit_entry");
        portletURL.setParameter("folderId", String.valueOf(0L));
        portletURL.setParameter("showFolderSelector", Boolean.TRUE.toString());
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_bookmarks_web_portlet_BookmarksPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        return this._portletResourcePermission.contains(permissionChecker, groupId, "ADD_ENTRY");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }
}

