/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BookmarksEntryAssetRenderer
extends BaseJSPAssetRenderer<BookmarksEntry>
implements TrashRenderer {
    private final ModelResourcePermission<BookmarksEntry> _bookmarksEntryModelResourcePermission;
    private final BookmarksEntry _entry;

    public BookmarksEntryAssetRenderer(BookmarksEntry entry, ModelResourcePermission<BookmarksEntry> modelResourcePermission) {
        this._entry = entry;
        this._bookmarksEntryModelResourcePermission = modelResourcePermission;
    }

    public BookmarksEntry getAssetObject() {
        return this._entry;
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public long getClassPK() {
        return this._entry.getEntryId();
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._entry.getModifiedDate();
    }

    public long getGroupId() {
        return this._entry.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("full_content")) {
            return "/bookmarks/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._entry.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._entry.getDescription();
    }

    public String getTitle(Locale locale) {
        return this._entry.getName();
    }

    public String getType() {
        return "bookmark";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/bookmarks/edit_entry");
        portletURL.setParameter("folderId", String.valueOf(this._entry.getFolderId()));
        portletURL.setParameter("entryId", String.valueOf(this._entry.getEntryId()));
        portletURL.setParameter("showFolderSelector", Boolean.TRUE.toString());
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        return PortalUtil.getPathMain() + "/bookmarks/open_entry?entryId=" + this._entry.getEntryId();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/bookmarks/find_entry", "entryId", this._entry.getEntryId());
    }

    public long getUserId() {
        return this._entry.getUserId();
    }

    public String getUserName() {
        return this._entry.getUserName();
    }

    public String getUuid() {
        return this._entry.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        try {
            return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._entry, "UPDATE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        try {
            return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._entry, "VIEW");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("BOOKMARKS_ENTRY", (Object)this._entry);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return true;
    }
}

