/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.upload;

import com.liferay.blogs.exception.EntryImageNameException;
import com.liferay.blogs.exception.EntryImageSizeException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ImageBlogsUploadFileEntryHandler.class})
public class ImageBlogsUploadFileEntryHandler
implements UploadFileEntryHandler {
    @Reference
    protected BlogsEntryLocalService blogsLocalService;
    @Reference(target="(resource.name=com.liferay.blogs)")
    protected PortletResourcePermission portletResourcePermission;
    private static final String _PARAMETER_NAME = "imageSelectorFileName";

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this.portletResourcePermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup(), "ADD_ENTRY");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        long size = uploadPortletRequest.getSize(_PARAMETER_NAME);
        this._validateFile(fileName, size);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            FileEntry fileEntry = this.addFileEntry(fileName, contentType, inputStream, themeDisplay);
            return fileEntry;
        }
    }

    protected FileEntry addFileEntry(String fileName, String contentType, InputStream inputStream, ThemeDisplay themeDisplay) throws PortalException {
        Folder folder = this.blogsLocalService.addAttachmentsFolder(themeDisplay.getUserId(), themeDisplay.getScopeGroupId());
        String uniqueFileName = PortletFileRepositoryUtil.getUniqueFileName((long)themeDisplay.getScopeGroupId(), (long)folder.getFolderId(), (String)fileName);
        return PortletFileRepositoryUtil.addPortletFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)BlogsEntry.class.getName(), (long)0L, (String)"com.liferay.blogs", (long)folder.getFolderId(), (InputStream)inputStream, (String)uniqueFileName, (String)contentType, (boolean)true);
    }

    private void _validateFile(String fileName, long size) throws PortalException {
        String[] imageExtensions;
        if (PropsValues.BLOGS_IMAGE_MAX_SIZE > 0L && size > PropsValues.BLOGS_IMAGE_MAX_SIZE) {
            throw new EntryImageSizeException();
        }
        String extension = FileUtil.getExtension((String)fileName);
        for (String imageExtension : imageExtensions = PrefsPropsUtil.getStringArray((String)"blogs.image.extensions", (String)",")) {
            if (!"*".equals(imageExtension) && !imageExtension.equals("." + extension)) continue;
            return;
        }
        throw new EntryImageNameException("Invalid image for file name " + fileName);
    }
}

