/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.servlet.taglib.util;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.web.internal.security.permission.resource.BlogsEntryPermission;
import com.liferay.blogs.web.internal.util.BlogsEntryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.WorkflowedModel;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import com.liferay.trash.TrashHelper;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.ActionURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BlogsEntryActionDropdownItemsProvider {
    private final BlogsEntry _blogsEntry;
    private final HttpServletRequest _httpServletRequest;
    private final PermissionChecker _permissionChecker;
    private final RenderResponse _renderResponse;
    private final ResourceBundle _resourceBundle;
    private final TrashHelper _trashHelper;

    public BlogsEntryActionDropdownItemsProvider(BlogsEntry blogsEntry, RenderRequest renderRequest, RenderResponse renderResponse, PermissionChecker permissionChecker, ResourceBundle resourceBundle, TrashHelper trashHelper) {
        this._blogsEntry = blogsEntry;
        this._renderResponse = renderResponse;
        this._permissionChecker = permissionChecker;
        this._resourceBundle = resourceBundle;
        this._trashHelper = trashHelper;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                if (BlogsEntryActionDropdownItemsProvider.this._hasUpdatePermission()) {
                    this.add(BlogsEntryActionDropdownItemsProvider.this._getEditEntryActionUnsafeConsumer());
                }
                if (BlogsEntryActionDropdownItemsProvider.this._hasPermissionsPermission()) {
                    this.add(BlogsEntryActionDropdownItemsProvider.this._getPermissionsActionUnsafeConsumer());
                }
                if (BlogsEntryActionDropdownItemsProvider.this._hasDeletePermission()) {
                    if (BlogsEntryActionDropdownItemsProvider.this._isTrashEnabled()) {
                        this.add(BlogsEntryActionDropdownItemsProvider.this._getMoveEntryToTrashActionUnsafeConsumer());
                    } else {
                        this.add(BlogsEntryActionDropdownItemsProvider.this._getDeleteEntryActionUnsafeConsumer());
                    }
                }
                if (BlogsEntryActionDropdownItemsProvider.this._isShowPublishMenuItem() && BlogsEntryActionDropdownItemsProvider.this._hasExportImportPortletInfoPermission()) {
                    this.add(BlogsEntryActionDropdownItemsProvider.this._getPublishToLiveEntryActionUnsafeConsumer());
                }
            }
        };
    }

    private static boolean _isShowPublishMenuItem(Group group, String portletId) {
        try {
            if (group.isLayout()) {
                return false;
            }
            return (group.isStagingGroup() || group.isStagedRemotely()) && group.isStagedPortlet(portletId);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean _isShowPublishMenuItem(Group group, String portletId, String className, String uuid) {
        try {
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)className);
            StagedModel stagedModel = stagedModelDataHandler.fetchStagedModelByUuidAndGroupId(uuid, group.getGroupId());
            if (stagedModel == null) {
                return false;
            }
            if (stagedModel instanceof WorkflowedModel) {
                WorkflowedModel workflowedModel = (WorkflowedModel)stagedModel;
                if (!ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)workflowedModel.getStatus())) {
                    return false;
                }
            }
            return BlogsEntryActionDropdownItemsProvider._isShowPublishMenuItem(group, portletId);
        }
        catch (Exception e) {
            return false;
        }
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteEntryActionUnsafeConsumer() {
        ActionURL deleteURL = (ActionURL)this._renderResponse.createActionURL();
        deleteURL.setParameter("javax.portlet.action", "/blogs/edit_entry");
        deleteURL.setParameter("cmd", "delete");
        deleteURL.setParameter("redirect", this._getRedirectURL());
        deleteURL.setParameter("entryId", String.valueOf(this._blogsEntry.getEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "delete");
            dropdownItem.putData("deleteURL", deleteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditEntryActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/blogs/edit_entry", "cmd", "update", "redirect", this._getRedirectURL(), "entryId", this._blogsEntry.getEntryId()});
            dropdownItem.setIcon("edit");
            dropdownItem.setLabel(LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getMoveEntryToTrashActionUnsafeConsumer() {
        ActionURL moveToTrashURL = (ActionURL)this._renderResponse.createActionURL();
        moveToTrashURL.setParameter("javax.portlet.action", "/blogs/edit_entry");
        moveToTrashURL.setParameter("cmd", "move_to_trash");
        moveToTrashURL.setParameter("redirect", this._getRedirectURL());
        moveToTrashURL.setParameter("entryId", String.valueOf(this._blogsEntry.getEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "delete");
            dropdownItem.putData("deleteURL", moveToTrashURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"move-to-recycle-bin"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.putData("action", "permissions");
            dropdownItem.putData("permissionsURL", this._getPermissionsURL());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private String _getPermissionsURL() {
        try {
            return PermissionsURLTag.doTag((String)"", (String)BlogsEntry.class.getName(), (String)BlogsEntryUtil.getDisplayTitle(this._resourceBundle, this._blogsEntry), null, (String)String.valueOf(this._blogsEntry.getEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        }
        catch (Exception e) {
            return (String)ReflectionUtil.throwException((Throwable)e);
        }
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPublishToLiveEntryActionUnsafeConsumer() {
        PortletURL publishEntryURL = this._renderResponse.createActionURL();
        publishEntryURL.setParameter("javax.portlet.action", "/blogs/publish_entry");
        publishEntryURL.setParameter("backURL", this._getRedirectURL());
        publishEntryURL.setParameter("entryId", String.valueOf(this._blogsEntry.getEntryId()));
        return dropdownItem -> {
            dropdownItem.putData("action", "publishToLive");
            dropdownItem.putData("publishEntryURL", publishEntryURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"publish-to-live"));
        };
    }

    private String _getRedirectURL() {
        PortletURL redirectURL = this._renderResponse.createRenderURL();
        redirectURL.setParameter("mvcRenderCommandName", "/blogs/view");
        return redirectURL.toString();
    }

    private boolean _hasDeletePermission() {
        try {
            return BlogsEntryPermission.contains(this._permissionChecker, this._blogsEntry, "DELETE");
        }
        catch (PortalException pe) {
            return (Boolean)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private boolean _hasExportImportPortletInfoPermission() {
        try {
            return GroupPermissionUtil.contains((PermissionChecker)this._permissionChecker, (long)this._blogsEntry.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        }
        catch (PortalException pe) {
            return (Boolean)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private boolean _hasPermissionsPermission() {
        try {
            return BlogsEntryPermission.contains(this._permissionChecker, this._blogsEntry, "PERMISSIONS");
        }
        catch (PortalException pe) {
            return (Boolean)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private boolean _hasUpdatePermission() {
        try {
            return BlogsEntryPermission.contains(this._permissionChecker, this._blogsEntry, "UPDATE");
        }
        catch (PortalException pe) {
            return (Boolean)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private boolean _isShowPublishMenuItem() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return BlogsEntryActionDropdownItemsProvider._isShowPublishMenuItem(themeDisplay.getScopeGroup(), "com_liferay_blogs_web_portlet_BlogsAdminPortlet", BlogsEntry.class.getName(), this._blogsEntry.getUuid());
    }

    private boolean _isTrashEnabled() {
        try {
            return this._trashHelper.isTrashEnabled(PortalUtil.getScopeGroupId((HttpServletRequest)this._httpServletRequest));
        }
        catch (PortalException pe) {
            return (Boolean)ReflectionUtil.throwException((Throwable)pe);
        }
    }
}

