/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.servlet.taglib.clay;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.web.internal.security.permission.resource.BlogsEntryPermission;
import com.liferay.blogs.web.internal.servlet.taglib.util.BlogsEntryActionDropdownItemsProvider;
import com.liferay.blogs.web.internal.util.BlogsEntryUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseVerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BlogsEntryVerticalCard
extends BaseVerticalCard {
    private final BlogsEntry _blogsEntry;
    private final String _blogsEntryURL;
    private final PermissionChecker _permissionChecker;
    private final RenderResponse _renderResponse;
    private final ResourceBundle _resourceBundle;
    private final TrashHelper _trashHelper;

    public BlogsEntryVerticalCard(BlogsEntry blogsEntry, RenderRequest renderRequest, RenderResponse renderResponse, RowChecker rowChecker, TrashHelper trashHelper, String blogsEntryURL, PermissionChecker permissionChecker, ResourceBundle resourceBundle) {
        super((BaseModel)blogsEntry, renderRequest, rowChecker);
        this._blogsEntry = blogsEntry;
        this._renderResponse = renderResponse;
        this._trashHelper = trashHelper;
        this._blogsEntryURL = blogsEntryURL;
        this._permissionChecker = permissionChecker;
        this._resourceBundle = resourceBundle;
    }

    public List<DropdownItem> getActionDropdownItems() {
        BlogsEntryActionDropdownItemsProvider blogsEntryActionDropdownItemsProvider = new BlogsEntryActionDropdownItemsProvider(this._blogsEntry, this.renderRequest, this._renderResponse, this._permissionChecker, this._resourceBundle, this._trashHelper);
        return blogsEntryActionDropdownItemsProvider.getActionDropdownItems();
    }

    public String getDefaultEventHandler() {
        return "BLOGS_ELEMENTS_DEFAULT_EVENT_HANDLER";
    }

    public String getHref() {
        try {
            if (!BlogsEntryPermission.contains(this._permissionChecker, this._blogsEntry, "UPDATE")) {
                return null;
            }
            return this._blogsEntryURL;
        }
        catch (PortalException pe) {
            return (String)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    public String getIcon() {
        return "blogs";
    }

    public String getImageSrc() {
        try {
            String coverImageURL = this._blogsEntry.getCoverImageURL(this.themeDisplay);
            if (Validator.isNull((String)coverImageURL)) {
                return this._blogsEntry.getSmallImageURL(this.themeDisplay);
            }
            return coverImageURL;
        }
        catch (PortalException pe) {
            return (String)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    public String getSubtitle() {
        Date modifiedDate = this._blogsEntry.getModifiedDate();
        String modifiedDateDescription = LanguageUtil.getTimeDescription((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this.renderRequest), (long)(System.currentTimeMillis() - modifiedDate.getTime()), (boolean)true);
        return LanguageUtil.format((ResourceBundle)this._resourceBundle, (String)"x-ago-by-x", (Object[])new Object[]{modifiedDateDescription, HtmlUtil.escape((String)this._blogsEntry.getUserName())});
    }

    public String getTitle() {
        return BlogsEntryUtil.getDisplayTitle(this._resourceBundle, this._blogsEntry);
    }
}

