/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.servlet.taglib.clay;

import com.liferay.blogs.web.internal.servlet.taglib.util.BlogsEntryImageActionDropdownItemsProvider;
import com.liferay.document.library.util.DLURLHelperUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BlogsEntryImageVerticalCard
implements VerticalCard {
    private final FileEntry _fileEntry;
    private final HttpServletRequest _httpServletRequest;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final RowChecker _rowChecker;
    private final ThemeDisplay _themeDisplay;

    public BlogsEntryImageVerticalCard(FileEntry fileEntry, RenderRequest renderRequest, RenderResponse renderResponse, RowChecker rowChecker) {
        this._fileEntry = fileEntry;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._rowChecker = rowChecker;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        BlogsEntryImageActionDropdownItemsProvider blogsEntryImageActionDropdownItemsProvider = new BlogsEntryImageActionDropdownItemsProvider(this._fileEntry, this._renderRequest, this._renderResponse);
        return blogsEntryImageActionDropdownItemsProvider.getActionDropdownItems();
    }

    public String getIcon() {
        return "documents-and-media";
    }

    public String getImageSrc() {
        try {
            return DLURLHelperUtil.getThumbnailSrc((FileEntry)this._fileEntry, (ThemeDisplay)this._themeDisplay);
        }
        catch (Exception e) {
            return (String)ReflectionUtil.throwException((Throwable)e);
        }
    }

    public String getInputName() {
        return this._rowChecker.getRowIds();
    }

    public String getInputValue() {
        return String.valueOf(this._fileEntry.getPrimaryKeyObj());
    }

    public List<LabelItem> getLabels() {
        if (!this._fileEntry.isRepositoryCapabilityProvided(WorkflowCapability.class)) {
            return Collections.emptyList();
        }
        final WorkflowCapability workflowCapability = (WorkflowCapability)this._fileEntry.getRepositoryCapability(WorkflowCapability.class);
        return new LabelItemList(){
            {
                this.add(labelItem -> labelItem.setStatus(workflowCapability.getStatus(BlogsEntryImageVerticalCard.this._fileEntry)));
            }
        };
    }

    public String getStickerImageSrc() {
        try {
            User user = UserLocalServiceUtil.fetchUser((long)this._fileEntry.getUserId());
            if (user == null) {
                return "";
            }
            return user.getPortraitURL(this._themeDisplay);
        }
        catch (PortalException pe) {
            return (String)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    public String getStickerLabel() {
        User user = UserLocalServiceUtil.fetchUser((long)this._fileEntry.getUserId());
        if (user == null) {
            return "";
        }
        return user.getInitials();
    }

    public String getStickerShape() {
        return "circle";
    }

    public String getSubtitle() {
        Date modifiedDate = this._fileEntry.getModifiedDate();
        String modifiedDateDescription = LanguageUtil.getTimeDescription((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest), (long)(System.currentTimeMillis() - modifiedDate.getTime()), (boolean)true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"x-ago-by-x", (Object[])new Object[]{modifiedDateDescription, HtmlUtil.escape((String)this._fileEntry.getUserName())});
    }

    public String getTitle() {
        return this._fileEntry.getTitle();
    }

    public boolean isDisabled() {
        return this._rowChecker.isDisabled((Object)this._fileEntry);
    }

    public boolean isSelected() {
        return this._rowChecker.isChecked((Object)this._fileEntry);
    }
}

