/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.web.internal.portlet.action.ActionUtil;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderConstants;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/view_entry"}, service={MVCRenderCommand.class})
public class ViewEntryMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private Portal _portal;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        long assetCategoryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"categoryId");
        String assetCategoryName = ParamUtil.getString((PortletRequest)renderRequest, (String)"tag");
        if (assetCategoryId > 0L || Validator.isNotNull((String)assetCategoryName)) {
            return "/blogs/view.jsp";
        }
        try {
            boolean redirectToLastFriendlyURL = ParamUtil.getBoolean((PortletRequest)renderRequest, (String)"redirectToLastFriendlyURL", (boolean)true);
            BlogsEntry entry = ActionUtil.getEntry((PortletRequest)renderRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String assetDisplayPageFriendlyURL = this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(BlogsEntry.class.getName(), entry.getEntryId(), themeDisplay);
            if (assetDisplayPageFriendlyURL != null) {
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                httpServletResponse.sendRedirect(assetDisplayPageFriendlyURL);
                return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
            }
            FriendlyURLEntry mainFriendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(BlogsEntry.class, entry.getEntryId());
            String urlTitle = ParamUtil.getString((PortletRequest)renderRequest, (String)"urlTitle");
            if (redirectToLastFriendlyURL && Validator.isNotNull((String)urlTitle) && !urlTitle.equals(mainFriendlyURLEntry.getUrlTitle())) {
                PortletURL portletURL = renderResponse.createRenderURL();
                portletURL.setParameter("mvcRenderCommandName", "/blogs/view_entry");
                portletURL.setParameter("urlTitle", mainFriendlyURLEntry.getUrlTitle());
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                httpServletResponse.sendRedirect(portletURL.toString());
                return MVCRenderConstants.MVC_PATH_VALUE_SKIP_DISPATCH;
            }
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)renderRequest);
            httpServletRequest.setAttribute("BLOGS_ENTRY", (Object)entry);
            if (PropsValues.BLOGS_PINGBACK_ENABLED && entry != null && entry.isAllowPingbacks()) {
                HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                httpServletResponse.addHeader("X-Pingback", this._portal.getPortalURL((PortletRequest)renderRequest) + "/xmlrpc/pingback");
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/blogs/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/blogs/view_entry.jsp";
    }
}

