/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.configuration.BlogsGroupServiceOverriddenConfiguration;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.rss.util.RSSUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"path=/blogs/rss"}, service={StrutsAction.class})
public class RSSAction
implements StrutsAction {
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.isRSSFeedsEnabled(httpServletRequest)) {
            this._portal.sendRSSFeedsDisabledError(httpServletRequest, httpServletResponse);
            return null;
        }
        try {
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null, (byte[])this.getRSS(httpServletRequest), (String)"text/xml; charset=UTF-8");
            return null;
        }
        catch (Exception e) {
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
            return null;
        }
    }

    protected byte[] getRSS(HttpServletRequest httpServletRequest) throws Exception {
        String feedURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long plid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid");
        if (plid == 0L) {
            plid = themeDisplay.getPlid();
        }
        long companyId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"companyId");
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        long organizationId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"organizationId");
        int status = 0;
        int max = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"max", (int)SearchContainer.DEFAULT_DELTA);
        String type = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"type", (String)RSSUtil.FORMAT_DEFAULT);
        double version = ParamUtil.getDouble((HttpServletRequest)httpServletRequest, (String)"version", (double)RSSUtil.VERSION_DEFAULT);
        String displayStyle = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"displayStyle", (String)RSSUtil.DISPLAY_STYLE_DEFAULT);
        String entryURL = feedURL = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/blogs/find_entry?";
        String rss = "";
        if (companyId > 0L) {
            feedURL = "";
            rss = this._blogsEntryService.getCompanyEntriesRSS(companyId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (groupId > 0L) {
            entryURL = feedURL = feedURL + "p_l_id=" + plid;
            rss = this._blogsEntryService.getGroupEntriesRSS(groupId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (organizationId > 0L) {
            feedURL = "";
            rss = this._blogsEntryService.getOrganizationEntriesRSS(organizationId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (layout != null) {
            groupId = themeDisplay.getScopeGroupId();
            entryURL = feedURL = themeDisplay.getPathMain() + "/blogs/rss";
            rss = this._blogsEntryService.getGroupEntriesRSS(groupId, new Date(), status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        }
        return rss.getBytes("UTF-8");
    }

    protected boolean isRSSFeedsEnabled(HttpServletRequest httpServletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        BlogsGroupServiceOverriddenConfiguration blogsGroupServiceOverriddenConfiguration = (BlogsGroupServiceOverriddenConfiguration)this._configurationProvider.getConfiguration(BlogsGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(themeDisplay.getSiteGroupId(), "com.liferay.blogs"));
        return blogsGroupServiceOverriddenConfiguration.enableRss();
    }
}

