/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "mvc.command.name=/blogs/publish_entry"}, service={MVCActionCommand.class})
public class PublishEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishEntryMVCActionCommand.class);
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private ExportImportChangesetMVCActionCommand _exportImportChangesetMVCActionCommand;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        Changeset.Builder builder = Changeset.create();
        Changeset changeset = builder.addStagedModel(() -> this._fetchEntry(entryId)).build();
        this._exportImportChangesetMVCActionCommand.processPublishAction(actionRequest, actionResponse, changeset);
    }

    private BlogsEntry _fetchEntry(long entryId) {
        try {
            return this._blogsEntryService.getEntry(entryId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get blogs entry " + entryId), (Throwable)pe);
            }
            return null;
        }
    }
}

