/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.exception.NoSuchEntryException;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.web.internal.BlogsItemSelectorHelper;
import com.liferay.blogs.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/edit_entry"}, service={MVCRenderCommand.class})
public class EditEntryMVCRenderCommand
implements MVCRenderCommand {
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private volatile ModelResourcePermission<BlogsEntry> _blogsEntryModelResourcePermission;
    @Reference
    private BlogsItemSelectorHelper _blogsItemSelectorHelper;
    @Reference
    private Portal _portal;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            BlogsEntry entry = ActionUtil.getEntry((PortletRequest)renderRequest);
            if (entry != null) {
                ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this._blogsEntryModelResourcePermission.check(themeDisplay.getPermissionChecker(), (ClassedModel)entry, "UPDATE");
            }
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)renderRequest);
            httpServletRequest.setAttribute("BLOGS_ENTRY", (Object)entry);
            renderRequest.setAttribute("BLOGS_ITEM_SELECTOR_HELPER", (Object)this._blogsItemSelectorHelper);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/blogs/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/blogs/edit_entry.jsp";
    }
}

