/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class BlogsExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference
    private BlogsEntryLocalService _blogsEntryLocalService;
    @Reference(target="(javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet)")
    private PortletDataHandler _blogsPortletDataHandler;
    @Reference(target="(name=BlogsExportCapability)")
    private Capability _blogsPortletDisplayTemplateExportCapability;
    @Reference(target="(name=BlogsImportCapability)")
    private Capability _blogsPortletDisplayTemplateImportCapability;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._blogsPortletDisplayTemplateExportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._blogsPortletDisplayTemplateImportCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.addPortletPermissions("com.liferay.blogs");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
            pde.setType(18);
            throw pde;
        }
        if (!portletDataContext.getBooleanParameter(this._blogsPortletDataHandler.getNamespace(), "entries")) {
            return portletPreferences;
        }
        String portletId = portletDataContext.getPortletId();
        ExportActionableDynamicQuery actionableDynamicQuery = this._blogsEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.setPerformActionMethod(blogsEntry -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)blogsEntry));
        try {
            actionableDynamicQuery.performActions();
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
            pde.setType(11);
            throw pde;
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!portletDataContext.getBooleanParameter(this._blogsPortletDataHandler.getNamespace(), "entries")) {
            return portletPreferences;
        }
        try {
            portletDataContext.importPortletPermissions("com.liferay.blogs");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_blogs_web_portlet_BlogsPortlet");
            pde.setType(20);
            throw pde;
        }
        Element entriesElement = portletDataContext.getImportDataGroupElement(BlogsEntry.class);
        List entryElements = entriesElement.elements();
        for (Element entryElement : entryElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)entryElement);
        }
        Element friendlyURLEntriesElement = portletDataContext.getImportDataGroupElement(FriendlyURLEntry.class);
        List friendlyURLEntryElements = friendlyURLEntriesElement.elements();
        for (Element friendlyURLEntryElement : friendlyURLEntryElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)friendlyURLEntryElement);
        }
        return portletPreferences;
    }
}

