/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessorHelper;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class BlogsAggregatorExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _exportCapability;
    @Reference
    private ExportImportPortletPreferencesProcessorHelper _exportImportPortletPreferencesProcessorHelper;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _importCapability;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private PortletLocalService _portletLocalService;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._exportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._importCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.updateExportPortletPreferences(portletDataContext, portletDataContext.getRootPortletId(), portletPreferences);
        }
        catch (Exception e) {
            return portletPreferences;
        }
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.updateImportPortletPreferences(portletDataContext, portletPreferences);
        }
        catch (Exception e) {
            return portletPreferences;
        }
    }

    protected PortletPreferences updateExportPortletPreferences(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        long organizationId = GetterUtil.getLong((String)portletPreferences.getValue("organizationId", null));
        if (organizationId > 0L) {
            Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
            Function<String, String> exportPortletPreferencesNewValueFunction = primaryKey -> {
                long primaryKeyLong = GetterUtil.getLong((String)primaryKey);
                Organization organization = this._organizationLocalService.fetchOrganization(primaryKeyLong);
                if (organization != null) {
                    portletDataContext.addReferenceElement((ClassedModel)portlet, portletDataContext.getExportDataRootElement(), (ClassedModel)organization, "dependency", true);
                    return organization.getUuid();
                }
                return null;
            };
            this._exportImportPortletPreferencesProcessorHelper.updateExportPortletPreferencesClassPKs(portletDataContext, portlet, portletPreferences, "organizationId", Organization.class.getName(), exportPortletPreferencesNewValueFunction);
        }
        return portletPreferences;
    }

    protected PortletPreferences updateImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        Company company = this._companyLocalService.getCompanyById(portletDataContext.getCompanyId());
        Group companyGroup = company.getGroup();
        Map primaryKeys = portletDataContext.getNewPrimaryKeysMap(Organization.class);
        Function<String, Long> importPortletPreferencesNewValueFunction = portletPreferencesOldValue -> {
            if (Validator.isNumber((String)portletPreferencesOldValue)) {
                long oldPrimaryKey = GetterUtil.getLong((String)portletPreferencesOldValue);
                return MapUtil.getLong((Map)primaryKeys, (long)oldPrimaryKey, (long)oldPrimaryKey);
            }
            Organization organization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(portletPreferencesOldValue, portletDataContext.getCompanyId());
            if (organization != null) {
                return organization.getOrganizationId();
            }
            return null;
        };
        this._exportImportPortletPreferencesProcessorHelper.updateImportPortletPreferencesClassPKs(portletDataContext, portletPreferences, "organizationId", companyGroup.getGroupId(), importPortletPreferencesNewValueFunction);
        return portletPreferences;
    }
}

