/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.blogs.web.internal.security.permission.resource.BlogsImagesFileEntryPermission;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogImagesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortalPreferences _portalPreferences;

    public BlogImagesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, PortletURL currentURLObj) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._httpServletRequest = httpServletRequest;
        this._currentURLObj = currentURLObj;
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteImages");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._httpServletRequest, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public List<String> getAvailableActions(FileEntry fileEntry) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (BlogsImagesFileEntryPermission.contains(permissionChecker, fileEntry, "DELETE")) {
            availableActionDropdownItems.add("deleteImages");
        }
        return availableActionDropdownItems;
    }

    public String getDisplayStyle() {
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "images-display-style", "icon");
        } else {
            this._portalPreferences.setValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "images-display-style", displayStyle);
            this._httpServletRequest.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(BlogImagesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"title");
    }

    public String getOrderByType() {
        return ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"desc");
    }

    public String getSearchActionURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/blogs/view");
        searchURL.setParameter("navigation", "images");
        searchURL.setParameter("orderByCol", this.getOrderByCol());
        searchURL.setParameter("orderByType", this.getOrderByType());
        return searchURL.toString();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public ViewTypeItemList getViewTypes() {
        String keywords;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view");
        portletURL.setParameter("navigation", "images");
        int delta = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"delta");
        if (delta > 0) {
            portletURL.setParameter("delta", String.valueOf(delta));
        }
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        int cur = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"cur");
        if (cur > 0) {
            portletURL.setParameter("cur", String.valueOf(cur));
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        sortingURL.setParameter("cur", "0");
        String keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(BlogImagesManagementToolbarDisplayContext.this.getOrderByCol(), "title"));
                    dropdownItem.setHref(BlogImagesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "title"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._httpServletRequest, (String)"title"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(BlogImagesManagementToolbarDisplayContext.this.getOrderByCol(), "size"));
                    dropdownItem.setHref(BlogImagesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "size"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogImagesManagementToolbarDisplayContext.this._httpServletRequest, (String)"size"));
                });
            }
        };
    }
}

