/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.blogs.web.internal.security.permission.resource.BlogsPermission;
import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogEntriesManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private final String _displayStyle;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public BlogEntriesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, SearchContainer searchContainer, TrashHelper trashHelper, String displayStyle) {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, searchContainer);
        this._trashHelper = trashHelper;
        this._displayStyle = displayStyle;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    boolean trashEnabled = BlogEntriesManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(BlogEntriesManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId());
                    dropdownItem.setIcon(trashEnabled ? "trash" : "times-circle");
                    String label = "delete";
                    if (trashEnabled) {
                        label = "move-to-recycle-bin";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this.request, (String)label));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() {
        return this.getSearchActionURL();
    }

    public Map<String, Object> getComponentContext() throws PortalException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String cmd = "delete";
        if (this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroup())) {
            cmd = "move_to_trash";
        }
        context.put("deleteEntriesCmd", cmd);
        PortletURL deleteEntriesURL = this.liferayPortletResponse.createActionURL();
        deleteEntriesURL.setParameter("javax.portlet.action", "/blogs/edit_entry");
        context.put("deleteEntriesURL", deleteEntriesURL.toString());
        context.put("trashEnabled", this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroupId()));
        return context;
    }

    public CreationMenu getCreationMenu() {
        if (!BlogsPermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroupId(), "ADD_ENTRY")) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(BlogEntriesManagementToolbarDisplayContext.this.liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/blogs/edit_entry", "redirect", BlogEntriesManagementToolbarDisplayContext.this.currentURLObj.toString()});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this.request, (String)"add-blog-entry"));
                });
            }
        };
    }

    public String getDefaultEventHandler() {
        return "BLOG_ENTRIES_MANAGEMENT_TOOLBAR_DEFAULT_EVENT_HANDLER";
    }

    public List<LabelItem> getFilterLabelItems() {
        if (!Objects.equals(this.getNavigation(), "mine")) {
            return null;
        }
        return new LabelItemList(){
            {
                this.add(labelItem -> {
                    PortletURL removeLabelURL = BlogEntriesManagementToolbarDisplayContext.this.getPortletURL();
                    removeLabelURL.setParameter("entriesNavigation", (String)null);
                    labelItem.putData("removeLabelURL", removeLabelURL.toString());
                    labelItem.setCloseable(true);
                    User user = BlogEntriesManagementToolbarDisplayContext.this._themeDisplay.getUser();
                    String label = String.format("%s: %s", LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this.request, (String)"owner"), user.getFullName());
                    labelItem.setLabel(label);
                });
            }
        };
    }

    public String getSearchActionURL() {
        PortletURL searchURL = this.liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/blogs/view");
        String navigation = ParamUtil.getString((HttpServletRequest)this.request, (String)"navigation", (String)"entries");
        searchURL.setParameter("navigation", navigation);
        searchURL.setParameter("orderByCol", this.getOrderByCol());
        searchURL.setParameter("orderByType", this.getOrderByType());
        return searchURL.toString();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view");
        if (this.searchContainer.getDelta() > 0) {
            portletURL.setParameter("delta", String.valueOf(this.searchContainer.getDelta()));
        }
        portletURL.setParameter("orderBycol", this.searchContainer.getOrderByCol());
        portletURL.setParameter("orderByType", this.searchContainer.getOrderByType());
        portletURL.setParameter("entriesNavigation", this.getNavigation());
        if (this.searchContainer.getCur() > 0) {
            portletURL.setParameter("cur", String.valueOf(this.searchContainer.getCur()));
        }
        return new ViewTypeItemList(portletURL, this._displayStyle){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    protected String[] getNavigationKeys() {
        return new String[]{"all", "mine"};
    }

    protected String getNavigationParam() {
        return "entriesNavigation";
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(BlogEntriesManagementToolbarDisplayContext.this.getOrderByCol(), "title"));
                    dropdownItem.setHref(BlogEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "title"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this.request, (String)"title"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(BlogEntriesManagementToolbarDisplayContext.this.getOrderByCol(), "display-date"));
                    dropdownItem.setHref(BlogEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "display-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BlogEntriesManagementToolbarDisplayContext.this.request, (String)"display-date"));
                });
            }
        };
    }

    private PortletURL _getCurrentSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("mvcRenderCommandName", "/blogs/view");
        sortingURL.setParameter("cur", "0");
        String keywords = ParamUtil.getString((HttpServletRequest)this.request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }
}

