/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.blogs.service.BlogsEntryServiceUtil;
import com.liferay.blogs.web.internal.security.permission.resource.BlogsEntryPermission;
import com.liferay.blogs.web.internal.util.BlogsUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchContainerResults;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BlogEntriesDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(BlogEntriesDisplayContext.class);
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortalPreferences _portalPreferences;
    private Integer _status;
    private final TrashHelper _trashHelper;

    public BlogEntriesDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, TrashHelper trashHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._trashHelper = trashHelper;
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
        this._httpServletRequest = this._liferayPortletRequest.getHttpServletRequest();
    }

    public List<String> getAvailableActions(BlogsEntry blogsEntry) throws PortalException {
        ArrayList<String> availableActionDropdownItems = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (BlogsEntryPermission.contains(permissionChecker, blogsEntry, "DELETE")) {
            availableActionDropdownItems.add("deleteEntries");
        }
        return availableActionDropdownItems;
    }

    public Map<String, Object> getComponentContext() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("trashEnabled", this._trashHelper.isTrashEnabled(themeDisplay.getScopeGroupId()));
        return context;
    }

    public String getDisplayStyle() {
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "entries-display-style", "icon");
        } else {
            this._portalPreferences.setValue("com_liferay_blogs_web_portlet_BlogsAdminPortlet", "entries-display-style", displayStyle);
            this._httpServletRequest.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        return displayStyle;
    }

    public SearchContainer getSearchContainer() throws PortalException, PortletException {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/blogs/view");
        String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"entriesNavigation");
        portletURL.setParameter("entriesNavigation", entriesNavigation);
        SearchContainer entriesSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)this._liferayPortletResponse), null, "no-entries-were-found");
        String orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"title");
        entriesSearchContainer.setOrderByCol(orderByCol);
        String orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        entriesSearchContainer.setOrderByType(orderByType);
        entriesSearchContainer.setOrderByComparator(BlogsUtil.getOrderByComparator(entriesSearchContainer.getOrderByCol(), entriesSearchContainer.getOrderByType()));
        entriesSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse));
        this._populateResults(entriesSearchContainer);
        return entriesSearchContainer;
    }

    private int _getStatus() {
        if (this._status != null) {
            return this._status;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        this._status = permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId()) ? Integer.valueOf(-1) : Integer.valueOf(0);
        return this._status;
    }

    private void _populateResults(SearchContainer searchContainer) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List<Object> entriesResults = null;
        long assetCategoryId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"categoryId");
        String assetTagName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"tag");
        String keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        if (assetCategoryId != 0L || Validator.isNotNull((String)assetTagName)) {
            SearchContainerResults<AssetEntry> searchContainerResults = BlogsUtil.getSearchContainerResults(searchContainer);
            searchContainer.setTotal(searchContainerResults.getTotal());
            List assetEntries = searchContainerResults.getResults();
            entriesResults = new ArrayList<BlogsEntry>(assetEntries.size());
            for (AssetEntry assetEntry : assetEntries) {
                entriesResults.add(BlogsEntryLocalServiceUtil.getEntry((long)assetEntry.getClassPK()));
            }
        } else if (Validator.isNull((String)keywords)) {
            String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"entriesNavigation");
            if (entriesNavigation.equals("mine")) {
                searchContainer.setTotal(BlogsEntryServiceUtil.getGroupUserEntriesCount((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)-1));
            } else {
                searchContainer.setTotal(BlogsEntryServiceUtil.getGroupEntriesCount((long)themeDisplay.getScopeGroupId(), (int)-1));
            }
            entriesResults = entriesNavigation.equals("mine") ? BlogsEntryServiceUtil.getGroupUserEntries((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)-1, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator()) : BlogsEntryServiceUtil.getGroupEntries((long)themeDisplay.getScopeGroupId(), (int)-1, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        } else {
            Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._httpServletRequest);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(this._getStatus()));
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setIncludeDiscussions(true);
            searchContext.setKeywords(keywords);
            searchContext.setStart(searchContainer.getStart());
            String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"entriesNavigation");
            if (entriesNavigation.equals("mine")) {
                searchContext.setOwnerUserId(themeDisplay.getUserId());
            }
            String orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"title");
            String orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
            Sort sort = null;
            boolean orderByAsc = true;
            if (Objects.equals(orderByType, "asc")) {
                orderByAsc = false;
            }
            sort = Objects.equals(orderByCol, "display-date") ? new Sort("displayDate", 6, orderByAsc) : new Sort(orderByCol, orderByAsc);
            searchContext.setSorts(new Sort[]{sort});
            Hits hits = indexer.search(searchContext);
            searchContainer.setTotal(hits.getLength());
            List searchResults = SearchResultUtil.getSearchResults((Hits)hits, (Locale)LocaleUtil.getDefault());
            Stream stream = searchResults.stream();
            entriesResults = stream.map(this::_toBlogsEntryOptional).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        searchContainer.setResults(entriesResults);
    }

    private Optional<BlogsEntry> _toBlogsEntryOptional(SearchResult searchResult) {
        try {
            return Optional.of(BlogsEntryServiceUtil.getEntry((long)searchResult.getClassPK()));
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Blogs search index is stale and contains entry " + searchResult.getClassPK()));
            }
            return Optional.empty();
        }
    }
}

