/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.editor.configuration;

import com.liferay.blogs.web.internal.configuration.BlogsPortletInstanceConfiguration;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"editor.config.key=contentEditor", "editor.name=alloyeditor", "editor.name=ckeditor", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "service.ranking:Integer=101"}, service={EditorConfigContributor.class})
public class BlogsReadingTimeEditorConfigContributor
extends BaseEditorConfigContributor {
    private static final Log _log = LogFactoryUtil.getLog(BlogsReadingTimeEditorConfigContributor.class);
    @Reference(target="(editor.config.key=reading-time-editor-config-key)")
    private EditorConfigContributor _readingTimeConfigContributor;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        try {
            BlogsPortletInstanceConfiguration blogsPortletInstanceConfiguration = (BlogsPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(BlogsPortletInstanceConfiguration.class);
            if (!blogsPortletInstanceConfiguration.enableReadingTime()) {
                return;
            }
        }
        catch (ConfigurationException ce) {
            _log.error((Object)"Unable to get blogs portlet instance configuration", (Throwable)ce);
        }
        String extraPlugins = jsonObject.getString("extraPlugins");
        extraPlugins = Validator.isNotNull((String)extraPlugins) ? extraPlugins + ",readingtime" : "readingtime";
        jsonObject.put("extraPlugins", extraPlugins);
        String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
        JSONObject readingTimeJSONObject = jsonObject.getJSONObject("readingTime");
        if (readingTimeJSONObject != null) {
            readingTimeJSONObject.put("elementId", namespace + "readingTime");
        }
        this._readingTimeConfigContributor.populateConfigJSONObject(jsonObject, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
    }
}

