/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.blogs.service.BlogsEntryServiceUtil;
import com.liferay.blogs.web.internal.util.BlogsUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.dao.search.SearchContainerResults;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class BlogEntriesDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(BlogEntriesDisplayContext.class);
    private final LiferayPortletRequest _liferayPortletRequest;
    private final HttpServletRequest _request;
    private Integer _status;

    public BlogEntriesDisplayContext(LiferayPortletRequest liferayPortletRequest) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._request = this._liferayPortletRequest.getHttpServletRequest();
    }

    public void populateResults(SearchContainer searchContainer) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List<BlogsEntry> entriesResults = null;
        long assetCategoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"categoryId");
        String assetTagName = ParamUtil.getString((HttpServletRequest)this._request, (String)"tag");
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (assetCategoryId != 0L || Validator.isNotNull((String)assetTagName)) {
            SearchContainerResults<AssetEntry> searchContainerResults = BlogsUtil.getSearchContainerResults(searchContainer);
            searchContainer.setTotal(searchContainerResults.getTotal());
            List assetEntries = searchContainerResults.getResults();
            entriesResults = new ArrayList<BlogsEntry>(assetEntries.size());
            for (AssetEntry assetEntry : assetEntries) {
                entriesResults.add(BlogsEntryLocalServiceUtil.getEntry((long)assetEntry.getClassPK()));
            }
        } else if (Validator.isNull((String)keywords)) {
            String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation");
            if (entriesNavigation.equals("mine")) {
                searchContainer.setTotal(BlogsEntryServiceUtil.getGroupUserEntriesCount((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)-1));
            } else {
                searchContainer.setTotal(BlogsEntryServiceUtil.getGroupEntriesCount((long)themeDisplay.getScopeGroupId(), (int)-1));
            }
            entriesResults = entriesNavigation.equals("mine") ? BlogsEntryServiceUtil.getGroupUserEntries((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)-1, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator()) : BlogsEntryServiceUtil.getGroupEntries((long)themeDisplay.getScopeGroupId(), (int)-1, (int)searchContainer.getStart(), (int)searchContainer.getEnd(), (OrderByComparator)searchContainer.getOrderByComparator());
        } else {
            Indexer indexer = IndexerRegistryUtil.getIndexer(BlogsEntry.class);
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(this._getStatus()));
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setKeywords(keywords);
            searchContext.setStart(searchContainer.getStart());
            String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation");
            if (entriesNavigation.equals("mine")) {
                searchContext.setOwnerUserId(themeDisplay.getUserId());
            }
            String orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"title");
            String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
            Sort sort = null;
            boolean orderByAsc = true;
            if (Objects.equals(orderByType, "asc")) {
                orderByAsc = false;
            }
            sort = "display-date".equals(orderByCol) ? new Sort("displayDate", 6, orderByAsc) : new Sort(orderByCol, orderByAsc);
            searchContext.setSorts(new Sort[]{sort});
            Hits hits = indexer.search(searchContext);
            entriesResults = new ArrayList(hits.getLength());
            searchContainer.setTotal(hits.getLength());
            Document[] docs = hits.getDocs();
            for (int i = 0; i < docs.length; ++i) {
                Document doc = hits.doc(i);
                long entryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
                BlogsEntry entry = null;
                try {
                    entry = BlogsEntryServiceUtil.getEntry((long)entryId);
                    entry = entry.toEscapedModel();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Blogs search index is stale and contains entry " + entryId));
                    continue;
                }
                entriesResults.add(entry);
            }
        }
        searchContainer.setResults(entriesResults);
    }

    private int _getStatus() {
        if (this._status != null) {
            return this._status;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        this._status = permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId()) ? Integer.valueOf(-1) : Integer.valueOf(0);
        return this._status;
    }
}

