/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.social;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.social.kernel.model.BaseSocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet"}, service={SocialActivityInterpreter.class})
public class BlogsActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    private BlogsEntryLocalService _blogsEntryLocalService;
    private ResourceBundleLoader _resourceBundleLoader;

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/blogs/find_entry?entryId=" + activity.getClassPK();
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) throws Exception {
        String creatorUserName = this.getUserName(activity.getUserId(), serviceContext);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), serviceContext);
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(activity.getClassPK());
        String displayDate = "";
        if (activity.getType() == 2 && entry.getStatus() == 7) {
            link = null;
            Format dateFormatDate = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"MMMM d", (Locale)serviceContext.getLocale(), (TimeZone)serviceContext.getTimeZone());
            displayDate = dateFormatDate.format(entry.getDisplayDate());
        }
        return new Object[]{groupName, creatorUserName, receiverUserName, this.wrapLink(link, title), displayDate};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) throws Exception {
        int activityType = activity.getType();
        if (activityType == 1 || activityType == 10005) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-add-comment";
            }
            return "activity-blogs-entry-add-comment-in";
        }
        if (activityType == 2) {
            BlogsEntry entry = this._blogsEntryLocalService.getEntry(activity.getClassPK());
            if (entry.getStatus() == 7) {
                if (Validator.isNull((String)groupName)) {
                    return "activity-blogs-entry-schedule-entry";
                }
                return "activity-blogs-entry-schedule-entry-in";
            }
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-add-entry";
            }
            return "activity-blogs-entry-add-entry-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-move-to-trash";
            }
            return "activity-blogs-entry-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-restore-from-trash";
            }
            return "activity-blogs-entry-restore-from-trash-in";
        }
        if (activityType == 3) {
            if (Validator.isNull((String)groupName)) {
                return "activity-blogs-entry-update-entry";
            }
            return "activity-blogs-entry-update-entry-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        return BlogsEntryPermission.contains((PermissionChecker)permissionChecker, (long)activity.getClassPK(), (String)actionId);
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(target="(bundle.symbolic.name=com.liferay.blogs.web)", unbind="-")
    protected void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
    }
}

