/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.upload;

import com.liferay.blogs.web.internal.upload.ImageBlogsUploadFileEntryHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.upload.UniqueFileNameProvider;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TempImageBlogsUploadFileEntryHandler.class})
public class TempImageBlogsUploadFileEntryHandler
extends ImageBlogsUploadFileEntryHandler {
    private static final String _TEMP_FOLDER_NAME = TempImageBlogsUploadFileEntryHandler.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(TempImageBlogsUploadFileEntryHandler.class);
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    @Override
    protected FileEntry addFileEntry(String fileName, String contentType, InputStream inputStream, ThemeDisplay themeDisplay) throws PortalException {
        String uniqueFileName = this._uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay, (String)curFileName));
        return TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)uniqueFileName, (InputStream)inputStream, (String)contentType);
    }

    private boolean _exists(ThemeDisplay themeDisplay, String curFileName) {
        try {
            return TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)curFileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

