/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.blogs.kernel.exception.NoSuchEntryException;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/view_entry"}, service={MVCRenderCommand.class})
public class ViewEntryMVCRenderCommand
implements MVCRenderCommand {
    @Reference
    private Portal _portal;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        long assetCategoryId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"categoryId");
        String assetCategoryName = ParamUtil.getString((PortletRequest)renderRequest, (String)"tag");
        if (assetCategoryId > 0L || Validator.isNotNull((String)assetCategoryName)) {
            return "/blogs/view.jsp";
        }
        try {
            BlogsEntry entry;
            ActionUtil.getEntry((PortletRequest)renderRequest);
            if (PropsValues.BLOGS_PINGBACK_ENABLED && (entry = (BlogsEntry)renderRequest.getAttribute("BLOGS_ENTRY")) != null && entry.isAllowPingbacks()) {
                HttpServletResponse response = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
                response.addHeader("X-Pingback", this._portal.getPortalURL((PortletRequest)renderRequest) + "/xmlrpc/pingback");
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/blogs/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/blogs/view_entry.jsp";
    }
}

