/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.blogs.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.blogs.kernel.exception.EntryContentException;
import com.liferay.blogs.kernel.exception.EntryCoverImageCropException;
import com.liferay.blogs.kernel.exception.EntryDescriptionException;
import com.liferay.blogs.kernel.exception.EntryDisplayDateException;
import com.liferay.blogs.kernel.exception.EntrySmallImageNameException;
import com.liferay.blogs.kernel.exception.EntrySmallImageScaleException;
import com.liferay.blogs.kernel.exception.EntryTitleException;
import com.liferay.blogs.kernel.exception.NoSuchEntryException;
import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalService;
import com.liferay.blogs.kernel.service.BlogsEntryService;
import com.liferay.blogs.util.BlogsEntryAttachmentContentUpdater;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.servlet.taglib.ui.ImageSelector;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.blogs.BlogsEntryAttachmentFileEntryHelper;
import com.liferay.portlet.blogs.BlogsEntryImageSelectorHelper;
import com.liferay.trash.kernel.service.TrashEntryService;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_blogs_web_portlet_BlogsPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAdminPortlet", "javax.portlet.name=com_liferay_blogs_web_portlet_BlogsAgreggatorPortlet", "mvc.command.name=/blogs/edit_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditEntryMVCActionCommand.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private BlogsEntryAttachmentContentUpdater _blogsEntryAttachmentContentUpdater;
    private BlogsEntryLocalService _blogsEntryLocalService;
    private BlogsEntryService _blogsEntryService;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    private TrashEntryService _trashEntryService;

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteEntryIds = null;
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        deleteEntryIds = entryId > 0L ? new long[]{entryId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteEntryIds"), (long)0L);
        ArrayList<BlogsEntry> trashedModels = new ArrayList<BlogsEntry>();
        for (long deleteEntryId : deleteEntryIds) {
            if (moveToTrash) {
                BlogsEntry entry = this._blogsEntryService.moveEntryToTrash(deleteEntryId);
                trashedModels.add(entry);
                continue;
            }
            this._blogsEntryService.deleteEntry(deleteEntryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".hideDefaultSuccessMessage"));
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BlogsEntry entry = null;
            String oldUrlTitle = "";
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add") || cmd.equals("update")) {
                UpdateEntryCallable updateEntryCallable = new UpdateEntryCallable(actionRequest);
                Object[] returnValue = (Object[])TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)updateEntryCallable);
                entry = (BlogsEntry)returnValue[0];
                oldUrlTitle = (String)returnValue[1];
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribe(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribe(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            boolean updateRedirect = false;
            String portletId = this._http.getParameter(redirect, "p_p_id", false);
            if (Validator.isNotNull((String)oldUrlTitle)) {
                String oldRedirectParam = this._portal.getPortletNamespace(portletId) + "redirect";
                String oldRedirect = this._http.getParameter(redirect, oldRedirectParam, false);
                if (Validator.isNotNull((String)oldRedirect)) {
                    String newRedirect = this._http.decodeURL(oldRedirect);
                    newRedirect = StringUtil.replace((String)newRedirect, (String)oldUrlTitle, (String)entry.getUrlTitle());
                    newRedirect = StringUtil.replace((String)newRedirect, (String)oldRedirectParam, (String)"redirect");
                    redirect = StringUtil.replace((String)redirect, (String)oldRedirect, (String)newRedirect);
                } else if (redirect.endsWith("/blogs/" + oldUrlTitle) || redirect.contains("/blogs/" + oldUrlTitle + "?") || redirect.contains("/blog/" + oldUrlTitle + "?")) {
                    redirect = StringUtil.replace((String)redirect, (String)oldUrlTitle, (String)entry.getUrlTitle());
                }
                updateRedirect = true;
            }
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)2);
            boolean ajax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ajax");
            if (ajax) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("attributeDataImageId", "data-image-id");
                jsonObject.put("content", entry.getContent());
                jsonObject.put("coverImageFileEntryId", entry.getCoverImageFileEntryId());
                jsonObject.put("entryId", entry.getEntryId());
                jsonObject.put("redirect", redirect);
                jsonObject.put("updateRedirect", updateRedirect);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
                return;
            }
            if (entry != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(actionRequest, entry, redirect);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = this._portal.escapeRedirect(redirect)))) {
                    if (cmd.equals("add") && entry != null) {
                        String namespace = this._portal.getPortletNamespace(portletId);
                        redirect = this._http.addParameter(redirect, namespace + "className", BlogsEntry.class.getName());
                        redirect = this._http.addParameter(redirect, namespace + "classPK", entry.getEntryId());
                    }
                    actionRequest.setAttribute("REDIRECT", (Object)redirect);
                }
            }
        }
        catch (AssetCategoryException | AssetTagException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            actionResponse.setRenderParameter("mvcRenderCommandName", "/blogs/edit_entry");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (EntryContentException | EntryCoverImageCropException | EntryDescriptionException | EntryDisplayDateException | EntrySmallImageNameException | EntrySmallImageScaleException | EntryTitleException | FileSizeException | SanitizerException | LiferayFileItemException | UploadRequestSizeException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcRenderCommandName", "/blogs/edit_entry");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (NoSuchEntryException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
            actionResponse.setRenderParameter("mvcPath", "/blogs/error.jsp");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, BlogsEntry entry, String redirect) throws Exception {
        PortletConfig portletConfig = (PortletConfig)actionRequest.getAttribute("javax.portlet.config");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/blogs/edit_entry");
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("groupId", String.valueOf(entry.getGroupId()), false);
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(policyOption=ReferencePolicyOption.GREEDY, unbind="-")
    protected void setBlogsEntryAttachmentContentUpdater(BlogsEntryAttachmentContentUpdater blogsEntryAttachmentContentUpdater) {
        this._blogsEntryAttachmentContentUpdater = blogsEntryAttachmentContentUpdater;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryService(BlogsEntryService blogsEntryService) {
        this._blogsEntryService = blogsEntryService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected void subscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._blogsEntryService.subscribe(themeDisplay.getScopeGroupId());
    }

    protected void unsubscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._blogsEntryService.unsubscribe(themeDisplay.getScopeGroupId());
    }

    protected Object[] updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String subtitle = ParamUtil.getString((PortletRequest)actionRequest, (String)"subtitle");
        String description = "";
        boolean customAbstract = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"customAbstract");
        if (customAbstract && Validator.isNull((String)(description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description")))) {
            throw new EntryDescriptionException();
        }
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int displayDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
        boolean allowTrackbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowTrackbacks");
        String[] trackbacks = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"trackbacks"));
        long coverImageFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"coverImageFileEntryId");
        String coverImageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageURL");
        String coverImageFileEntryCropRegion = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageFileEntryCropRegion");
        String coverImageCaption = ParamUtil.getString((PortletRequest)actionRequest, (String)"coverImageCaption");
        long oldCoverImageId = 0L;
        String oldCoverImageURL = "";
        long oldSmallImageId = 0L;
        String oldSmallImageURL = "";
        if (entryId != 0L) {
            BlogsEntry entry = this._blogsEntryLocalService.getBlogsEntry(entryId);
            oldCoverImageId = entry.getCoverImageFileEntryId();
            oldCoverImageURL = entry.getCoverImageURL();
            oldSmallImageId = entry.getSmallImageId();
            oldSmallImageURL = entry.getSmallImageURL();
        }
        BlogsEntryImageSelectorHelper blogsEntryCoverImageSelectorHelper = new BlogsEntryImageSelectorHelper(coverImageFileEntryId, oldCoverImageId, coverImageFileEntryCropRegion, coverImageURL, oldCoverImageURL);
        ImageSelector coverImageImageSelector = blogsEntryCoverImageSelectorHelper.getImageSelector();
        long smallImageFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"smallImageFileEntryId");
        String smallImageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"smallImageURL");
        BlogsEntryImageSelectorHelper blogsEntrySmallImageSelectorHelper = new BlogsEntryImageSelectorHelper(smallImageFileEntryId, oldSmallImageId, "", smallImageURL, oldSmallImageURL);
        ImageSelector smallImageImageSelector = blogsEntrySmallImageSelectorHelper.getImageSelector();
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BlogsEntry.class.getName(), (PortletRequest)actionRequest);
        BlogsEntry entry = null;
        String oldUrlTitle = "";
        List blogsEntryAttachmentFileEntryReferences = new ArrayList();
        if (entryId <= 0L) {
            entry = this._blogsEntryService.addEntry(title, subtitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
            BlogsEntryAttachmentFileEntryHelper blogsEntryAttachmentFileEntryHelper = new BlogsEntryAttachmentFileEntryHelper();
            List tempBlogsEntryAttachments = blogsEntryAttachmentFileEntryHelper.getTempBlogsEntryAttachmentFileEntries(content);
            if (!tempBlogsEntryAttachments.isEmpty()) {
                Folder folder = this._blogsEntryLocalService.addAttachmentsFolder(themeDisplay.getUserId(), entry.getGroupId());
                blogsEntryAttachmentFileEntryReferences = blogsEntryAttachmentFileEntryHelper.addBlogsEntryAttachmentFileEntries(entry.getGroupId(), themeDisplay.getUserId(), entry.getEntryId(), folder.getFolderId(), tempBlogsEntryAttachments);
                content = this._blogsEntryAttachmentContentUpdater.updateContent(content, blogsEntryAttachmentFileEntryReferences);
                entry.setContent(content);
                this._blogsEntryLocalService.updateBlogsEntry(entry);
            }
            for (FileEntry tempBlogsEntryAttachment : tempBlogsEntryAttachments) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)tempBlogsEntryAttachment.getFileEntryId());
            }
        } else {
            boolean sendEmailEntryUpdated = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"sendEmailEntryUpdated");
            serviceContext.setAttribute("sendEmailEntryUpdated", (Serializable)Boolean.valueOf(sendEmailEntryUpdated));
            String emailEntryUpdatedComment = ParamUtil.getString((PortletRequest)actionRequest, (String)"emailEntryUpdatedComment");
            serviceContext.setAttribute("emailEntryUpdatedComment", (Serializable)((Object)emailEntryUpdatedComment));
            entry = this._blogsEntryLocalService.getEntry(entryId);
            String tempOldUrlTitle = entry.getUrlTitle();
            BlogsEntryAttachmentFileEntryHelper blogsEntryAttachmentHelper = new BlogsEntryAttachmentFileEntryHelper();
            List tempBlogsEntryAttachmentFileEntries = blogsEntryAttachmentHelper.getTempBlogsEntryAttachmentFileEntries(content);
            if (!tempBlogsEntryAttachmentFileEntries.isEmpty()) {
                Folder folder = this._blogsEntryLocalService.addAttachmentsFolder(themeDisplay.getUserId(), entry.getGroupId());
                blogsEntryAttachmentFileEntryReferences = blogsEntryAttachmentHelper.addBlogsEntryAttachmentFileEntries(entry.getGroupId(), themeDisplay.getUserId(), entry.getEntryId(), folder.getFolderId(), tempBlogsEntryAttachmentFileEntries);
                content = this._blogsEntryAttachmentContentUpdater.updateContent(content, blogsEntryAttachmentFileEntryReferences);
            }
            entry = this._blogsEntryService.updateEntry(entryId, title, subtitle, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, coverImageCaption, coverImageImageSelector, smallImageImageSelector, serviceContext);
            for (FileEntry tempBlogsEntryAttachmentFileEntry : tempBlogsEntryAttachmentFileEntries) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)tempBlogsEntryAttachmentFileEntry.getFileEntryId());
            }
            if (!tempOldUrlTitle.equals(entry.getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
        }
        if (blogsEntryCoverImageSelectorHelper.isFileEntryTempFile()) {
            this._blogsEntryLocalService.addOriginalImageFileEntry(themeDisplay.getUserId(), entry.getGroupId(), entry.getEntryId(), coverImageImageSelector);
            PortletFileRepositoryUtil.deletePortletFileEntry((long)coverImageFileEntryId);
        }
        if (blogsEntrySmallImageSelectorHelper.isFileEntryTempFile()) {
            this._blogsEntryLocalService.addOriginalImageFileEntry(themeDisplay.getUserId(), entry.getGroupId(), entry.getEntryId(), smallImageImageSelector);
            PortletFileRepositoryUtil.deletePortletFileEntry((long)smallImageFileEntryId);
        }
        return new Object[]{entry, oldUrlTitle, blogsEntryAttachmentFileEntryReferences};
    }

    private class UpdateEntryCallable
    implements Callable<Object[]> {
        private final ActionRequest _actionRequest;

        @Override
        public Object[] call() throws Exception {
            return EditEntryMVCActionCommand.this.updateEntry(this._actionRequest);
        }

        private UpdateEntryCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

